/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.NewReportPageSupport;
import org.eclipse.birt.report.designer.ui.wizards.INewLibraryCreationPage;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class WizardNewLibraryCreationPage
extends WizardPage
implements INewLibraryCreationPage {
    private static final String MSG_DUPLICATE_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.duplicate.fileName");
    private static final String MSG_EMPTY_FILE_LOCATION_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.locationDirectory");
    private static final String MSG_EMPTY_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.name");
    private static final String CREATING = Messages.getString((String)"NewReportWizard.text.Creating");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewReportWizard.text.OpenFileForEditing");
    private static final String SUFFIX = ".rptlibrary";
    private static final String TEMPLATE_FILE = "/templates/blank_library.rptlibrary";
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardNewLibraryCreationPage.this.setPageComplete(WizardNewLibraryCreationPage.this.validatePage());
        }
    };
    NewReportPageSupport pageSupport = new NewReportPageSupport();

    public WizardNewLibraryCreationPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setControl((Control)this.pageSupport.createComposite(parent));
        this.pageSupport.getFileNameField().addListener(24, this.locationModifyListener);
        this.pageSupport.getLocationPathField().addListener(24, this.locationModifyListener);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.pageSupport.getFileNameField().setFocus();
        }
    }

    public boolean validatePage() {
        if (this.getFileName().equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_NAME);
            return false;
        }
        String location = this.getContainerFullPath().toOSString();
        if (location.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_LOCATION_DIRECTORY);
            return false;
        }
        IPath path = !this.getFileName().endsWith(SUFFIX) ? this.getContainerFullPath().append(this.getFileName() + SUFFIX) : this.getContainerFullPath().append(this.getFileName());
        if (path.toFile().exists()) {
            this.setErrorMessage(MSG_DUPLICATE_FILE_NAME);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setContainerFullPath(IPath initPath) {
        this.pageSupport.setInitialFileLocation(initPath.toOSString());
    }

    public void setFileName(String initFileName) {
        this.pageSupport.setInitialFileName(initFileName);
    }

    public String getFileName() {
        return this.pageSupport.getFileName();
    }

    public IPath getContainerFullPath() {
        return this.pageSupport.getFileLocationFullPath();
    }

    public boolean performFinish() {
        final IPath locPath = this.getContainerFullPath();
        String fn = this.getFileName();
        final String fileName = !fn.endsWith(SUFFIX) ? fn + SUFFIX : fn;
        InputStream inputData = null;
        URL url = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.birt.report.designer.ui"), (IPath)new Path(TEMPLATE_FILE));
        if (url != null) {
            try {
                inputData = url.openStream();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        final InputStream stream = inputData;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                try {
                    WizardNewLibraryCreationPage.this.doFinish(locPath, fileName, stream, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionHandler.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private void doFinish(IPath locationPath, String fileName, InputStream stream, IProgressMonitor monitor) {
        monitor.beginTask(CREATING + fileName, 2);
        final File file = new File(locationPath.toString(), fileName);
        try {
            File container = new File(locationPath.toString());
            if (!container.exists()) {
                container.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            byte[] buff = new byte[stream.available()];
            stream.read(buff);
            out.write(buff);
            out.close();
            stream.close();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IEditorPart editorPart = page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.LibraryEditor", true);
                    ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                        model.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
                        model.save();
                        editorPart.doSave(null);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
        this.fireLibraryChanged(fileName);
    }

    private void fireLibraryChanged(String fileName) {
        SessionHandleAdapter.getInstance().getSessionHandle().fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(fileName));
    }
}

