/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.NewReportPageSupport;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class WizardNewReportCreationPage
extends WizardPage {
    private static final String MSG_DUPLICATE_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.duplicate.fileName");
    private static final String MSG_EMPTY_FILE_LOCATION_DIRECTORY = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.locationDirectory");
    private static final String MSG_EMPTY_FILE_NAME = Messages.getString((String)"WizardNewReportCreationPage.msg.empty.file.name");
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardNewReportCreationPage.this.setPageComplete(WizardNewReportCreationPage.this.validatePage());
        }
    };
    NewReportPageSupport pageSupport = new NewReportPageSupport();

    public WizardNewReportCreationPage(String pageName) {
        super(pageName);
    }

    public void setInitialFileName(String name) {
        this.pageSupport.setInitialFileName(name);
    }

    public void setInitialFileLocation(String path) {
        this.pageSupport.setInitialFileLocation(path);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setControl((Control)this.pageSupport.createComposite(parent));
        this.pageSupport.getFileNameField().addListener(24, this.locationModifyListener);
        this.pageSupport.getLocationPathField().addListener(24, this.locationModifyListener);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public String getFileName() {
        return this.pageSupport.getFileName();
    }

    public IPath getFileLocationFullPath() {
        return this.pageSupport.getFileLocationFullPath();
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.pageSupport.getFileNameField().setFocus();
        }
    }

    public boolean validatePage() {
        if (this.getFileName().equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_NAME);
            return false;
        }
        String location = this.getFileLocationFullPath().toOSString();
        if (location.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(MSG_EMPTY_FILE_LOCATION_DIRECTORY);
            return false;
        }
        IPath path = !this.getFileName().endsWith(".rptdesign") ? this.getFileLocationFullPath().append(this.getFileName() + ".rptdesign") : this.getFileLocationFullPath().append(this.getFileName());
        if (path.toFile().exists()) {
            this.setErrorMessage(MSG_DUPLICATE_FILE_NAME);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

