/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.manifest;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSourceWizardInfo;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;

public class UIExtensionManifest {
    static final String DATA_SOURCE_ELEMENT_NAME = "dataSourceUI";
    static final String DATA_SET_ELEMENT_NAME = "dataSetUI";
    static final String DATA_SOURCE_WIZARD_ELEMENT_NAME = "newDataSourceWizard";
    private String m_namespace;
    private String m_dataSourceElementId;
    private DataSourceWizardInfo m_dataSourceWizardInfo;
    private Hashtable m_dataSetUIElements;
    static final /* synthetic */ boolean $assertionsDisabled;

    UIExtensionManifest(IExtension dataSourceExtn) throws OdaException {
        IConfigurationElement dataSourceElement = UIManifestExplorer.getNamedElement(dataSourceExtn, DATA_SOURCE_ELEMENT_NAME);
        if (!$assertionsDisabled && dataSourceElement == null) {
            throw new AssertionError();
        }
        this.m_namespace = dataSourceExtn.getNamespaceIdentifier();
        this.m_dataSourceElementId = dataSourceElement.getAttribute("id");
        if (!($assertionsDisabled || this.m_dataSourceElementId != null && this.m_dataSourceElementId.length() > 0)) {
            throw new AssertionError();
        }
        IConfigurationElement[] newWizardElements = dataSourceElement.getChildren(DATA_SOURCE_WIZARD_ELEMENT_NAME);
        if (newWizardElements.length < 1) {
            throw new OdaException(Messages.bind((String)Messages.manifest_missingAttributeValue, (Object)DATA_SOURCE_WIZARD_ELEMENT_NAME));
        }
        this.m_dataSourceWizardInfo = new DataSourceWizardInfo(newWizardElements[0]);
        this.m_dataSetUIElements = this.getDataSetUIElements(dataSourceExtn);
    }

    private UIExtensionManifest() {
    }

    private Hashtable getDataSetUIElements(IExtension extension) throws OdaException {
        Hashtable<String, DataSetUIElement> dataSetElements = new Hashtable<String, DataSetUIElement>();
        IConfigurationElement[] configElements = UIManifestExplorer.getNamedElements(extension, DATA_SET_ELEMENT_NAME);
        int size = configElements.length;
        for (int i = 0; i < size; ++i) {
            IConfigurationElement configElement = configElements[i];
            String dataSetId = configElement.getAttribute("id");
            dataSetElements.put(dataSetId, new DataSetUIElement(configElement));
        }
        if (dataSetElements.size() < 1) {
            throw new OdaException(Messages.bind((String)Messages.manifest_dataSetUi_missingElement, (Object)DATA_SET_ELEMENT_NAME));
        }
        return dataSetElements;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getDataSourceElementId() {
        return this.m_dataSourceElementId;
    }

    public DataSourceWizardInfo getDataSourceWizardInfo() {
        return this.m_dataSourceWizardInfo;
    }

    public DataSetUIElement[] getDataSetUIElements() {
        if (this.m_dataSetUIElements == null) {
            return new DataSetUIElement[0];
        }
        Collection dataSetUIs = this.m_dataSetUIElements.values();
        return dataSetUIs.toArray(new DataSetUIElement[dataSetUIs.size()]);
    }

    public String[] getDataSetUIElementIDs() {
        if (this.m_dataSetUIElements == null) {
            return new String[0];
        }
        Set dataSetIDs = this.m_dataSetUIElements.keySet();
        return dataSetIDs.toArray(new String[dataSetIDs.size()]);
    }

    public DataSetUIElement getDataSetUIElement(String dataSetElementID) throws OdaException {
        if (dataSetElementID == null || dataSetElementID.length() == 0) {
            if (this.m_dataSetUIElements == null || this.m_dataSetUIElements.size() != 1) {
                throw new OdaException(Messages.manifest_missingDataSetElementId);
            }
            Collection dataSetTypes = this.m_dataSetUIElements.values();
            if (!$assertionsDisabled && dataSetTypes.size() != 1) {
                throw new AssertionError();
            }
            return (DataSetUIElement)dataSetTypes.toArray()[0];
        }
        DataSetUIElement dataSetUIDefn = (DataSetUIElement)this.m_dataSetUIElements.get(dataSetElementID);
        if (dataSetUIDefn == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_invalidDataSetElementId, (Object)dataSetElementID));
        }
        return dataSetUIDefn;
    }

    static {
        $assertionsDisabled = !UIExtensionManifest.class.desiredAssertionStatus();
    }
}

