/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchive;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.AbstractRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.emitter.ReportEmitterExecutor;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.presentation.ReportDocumentBuilder;

public class RunTask
extends AbstractRunTask
implements IRunTask {
    private String reportDocName;
    private IDocArchiveWriter archive;
    private ReportDocumentWriter writer;
    private IPageHandler pageHandler;
    private ReportDocumentBuilder documentBuilder;

    public RunTask(IReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable);
        this.executionContext.setFactoryMode(true);
        this.executionContext.setPresentationMode(false);
    }

    public void setPageHandler(IPageHandler callback) {
        this.pageHandler = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String reportDocName) throws EngineException {
        try {
            this.runningStatus = 1;
            if (reportDocName == null || reportDocName.length() == 0) {
                throw new EngineException("Report document name is not specified when running a report.");
            }
            this.reportDocName = reportDocName;
            this.doRun();
        }
        finally {
            this.runningStatus = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IDocArchiveWriter archive) throws EngineException {
        try {
            this.runningStatus = 1;
            if (archive == null) {
                throw new EngineException("Report archive is not specified when running a report.");
            }
            this.archive = archive;
            this.doRun();
        }
        finally {
            this.runningStatus = 2;
        }
    }

    private IDocArchiveWriter openArchive(String reportDocName) throws IOException {
        File file = new File(reportDocName);
        Object archive = file.exists() ? (file.isDirectory() ? new FolderArchiveWriter(reportDocName) : new FileArchiveWriter(reportDocName)) : (reportDocName.endsWith("\\") || reportDocName.endsWith("/") ? new FolderArchiveWriter(reportDocName) : new FileArchiveWriter(reportDocName));
        return archive;
    }

    private void openReportDocument() throws EngineException {
        try {
            if (this.archive == null) {
                this.archive = this.openArchive(this.reportDocName);
            }
            this.archive.initialize();
        }
        catch (IOException ex) {
            if (this.archive != null) {
                try {
                    this.archive.finish();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, " error in close archive ", e);
                }
            }
            throw new EngineException("Can not open the report archive.", ex);
        }
        this.writer = new ReportDocumentWriter(this.engine, this.archive);
        this.executionContext.setReportDocWriter(this.writer);
    }

    private void closeReportDocument() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        this.archive = null;
        this.reportDocName = null;
    }

    private void initializeContentEmitter(IContentEmitter emitter, IReportExecutor executor) {
        EngineEmitterServices services = new EngineEmitterServices(this);
        EngineConfig config = this.engine.getConfig();
        if (config != null) {
            HashMap emitterConfigs = config.getEmitterConfigs();
            services.setEmitterConfig(emitterConfigs);
        }
        services.setRenderOption(this.renderOptions);
        services.setExecutor(executor);
        services.setRenderContext(this.appContext);
        services.setReportRunnable(this.runnable);
        emitter.initialize(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doRun() throws EngineException {
        if (!this.validateParameters()) {
            throw new EngineException("Error.InvalidParameter");
        }
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.openReportDocument();
        try {
            try {
                ReportRunnable report = this.executionContext.getRunnable();
                this.writer.saveDesign(report);
                this.writer.saveParamters(this.inputValues);
                this.executionContext.openDataEngine();
                RunTask runTask = this;
                // MONITORENTER : runTask
                if (!this.executionContext.isCanceled()) {
                    this.documentBuilder = new ReportDocumentBuilder(this.executionContext, this.writer);
                }
                // MONITOREXIT : runTask
                if (this.documentBuilder != null) {
                    if (this.pageHandler != null) {
                        this.documentBuilder.setPageHandler(this.pageHandler);
                    }
                    IContentEmitter emitter = this.documentBuilder.getContentEmitter();
                    ReportExecutor reportExecutor = new ReportExecutor(this.executionContext);
                    ReportEmitterExecutor reportEmitterExecutor = new ReportEmitterExecutor(reportExecutor, emitter);
                    SuppressDuplciateReportExecutor suppressDuplciateReportExecutor = new SuppressDuplciateReportExecutor(reportEmitterExecutor);
                    this.executionContext.setExecutor(suppressDuplciateReportExecutor);
                    this.initializeContentEmitter(emitter, suppressDuplciateReportExecutor);
                    this.documentBuilder.build();
                }
                this.executionContext.closeDataEngine();
                this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
                throw new EngineException("Error happened while running the report", ex);
            }
            catch (OutOfMemoryError err) {
                log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
                throw err;
            }
            Object var5_8 = null;
            this.documentBuilder = null;
            this.closeReportDocument();
            if (this.pageHandler != null && !this.executionContext.isCanceled()) {
                int totalPage = (int)this.executionContext.getTotalPage();
                ReportDocumentInfo docInfo = new ReportDocumentInfo(this.executionContext, totalPage, true);
                this.pageHandler.onPage(totalPage, true, docInfo);
            }
            this.closeFactory();
            return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.documentBuilder = null;
            this.closeReportDocument();
            if (this.pageHandler != null && !this.executionContext.isCanceled()) {
                int totalPage = (int)this.executionContext.getTotalPage();
                ReportDocumentInfo docInfo = new ReportDocumentInfo(this.executionContext, totalPage, true);
                this.pageHandler.onPage(totalPage, true, docInfo);
            }
            this.closeFactory();
            throw throwable;
        }
    }

    public void close() {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FolderArchive fArchive) throws EngineException {
        try {
            this.runningStatus = 1;
            this.setDataSource((IDocArchiveReader)fArchive);
            this.run((IDocArchiveWriter)fArchive);
        }
        finally {
            this.runningStatus = 2;
        }
    }

    public void cancel() {
        super.cancel();
        if (this.documentBuilder != null) {
            this.documentBuilder.cancel();
        }
    }
}

