/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataGenerationEngine
extends AbstractDataEngine {
    protected HashMap queryMap = new HashMap();
    private DataOutputStream dos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataGenerationEngine(ExecutionContext context, IDocArchiveWriter writer) {
        super(context);
        try {
            DataEngineContext dteContext = DataEngineContext.newInstance((int)1, (Scriptable)context.getSharedScope(), null, (IDocArchiveWriter)writer);
            dteContext.setLocale(context.getLocale());
            String tempDir = this.getTempDir(context);
            if (tempDir != null) {
                dteContext.setTmpdir(tempDir);
            }
            this.dteEngine = DataEngine.newDataEngine((DataEngineContext)dteContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
            ex.printStackTrace();
        }
        try {
            this.dos = new DataOutputStream((OutputStream)writer.createRandomAccessStream("/Data/hierarchy"));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
        }
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
        for (int i = 0; i < report.getQueries().size(); ++i) {
            IQueryDefinition queryDef = (IQueryDefinition)report.getQueries().get(i);
            try {
                IPreparedQuery preparedQuery = this.dteEngine.prepare(queryDef, appContext);
                this.queryMap.put(queryDef, preparedQuery);
                continue;
            }
            catch (BirtException be) {
                logger.log(Level.SEVERE, be.getMessage());
                this.context.addException(be);
            }
        }
    }

    protected IResultSet doExecuteQuery(DteResultSet resultSet, IQueryDefinition query) {
        if (!$assertionsDisabled && !(query instanceof IQueryDefinition)) {
            throw new AssertionError();
        }
        IPreparedQuery pQuery = (IPreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            return null;
        }
        try {
            IQueryResults dteResults;
            String queryID = (String)this.queryIDMap.get(query);
            Scriptable scope = this.context.getSharedScope();
            String pRsetId = null;
            long rowId = -1L;
            if (resultSet == null) {
                dteResults = pQuery.execute(scope);
                resultSet = new DteResultSet(this, this.context, query, dteResults);
            } else {
                pRsetId = resultSet.getQueryResults().getID();
                rowId = resultSet.getRawID();
                dteResults = pQuery.execute(resultSet.getQueryResults(), scope);
                resultSet = new DteResultSet(resultSet, query, dteResults);
            }
            this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }

    public void shutdown() {
        if (null != this.dos) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dos = null;
        }
        this.dteEngine.shutdown();
    }

    private void storeDteMetaInfo(String pRsetId, long rowId, String queryId, String rsetId) {
        if (null != this.dos) {
            try {
                IOUtil.writeString((DataOutputStream)this.dos, (String)pRsetId);
                if (pRsetId == null && this.context.isExecutingMasterPage()) {
                    IOUtil.writeLong((DataOutputStream)this.dos, (long)this.context.getPageNumber());
                } else {
                    IOUtil.writeLong((DataOutputStream)this.dos, (long)rowId);
                }
                IOUtil.writeString((DataOutputStream)this.dos, (String)queryId);
                IOUtil.writeString((DataOutputStream)this.dos, (String)rsetId);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !DataGenerationEngine.class.desiredAssertionStatus();
    }
}

