/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;

public class DataItemExecutor
extends QueryItemExecutor {
    public DataItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        String bindingColumn;
        DataItemDesign dataDesign = (DataItemDesign)this.getDesign();
        IDataContent dataContent = this.report.createDataContent();
        this.setContent(dataContent);
        this.executeQuery();
        this.initializeContent(dataDesign, dataContent);
        this.processAction(dataDesign, dataContent);
        this.processBookmark(dataDesign, dataContent);
        this.processStyle(dataDesign, dataContent);
        this.processVisibility(dataDesign, dataContent);
        Object value = null;
        IResultSet rset = this.context.getResultSet();
        if (rset != null && (bindingColumn = dataDesign.getBindingColumn()) != null) {
            try {
                value = rset.getValue(bindingColumn);
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
        dataContent.setValue(value);
        this.processMappingValue(dataDesign, dataContent);
        if (this.context.isInFactory()) {
            DataItemScriptExecutor.handleOnCreate(dataContent, this.context);
        }
        this.startTOCEntry(dataContent);
        return dataContent;
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
        this.manager.releaseExecutor(7, this);
    }
}

