/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.SuppressDuplicateUtil;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.w3c.dom.css.CSSValue;

public abstract class GroupExecutor
extends ReportItemExecutor {
    boolean endOfGroup;
    boolean hiddenDetail;
    boolean needPageBreak;
    ListingElementExecutor listingExecutor;
    ReportItemDesign[] executableElements = new ReportItemDesign[3];
    int totalElements;
    int currentElement;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected GroupExecutor(ExecutorManager manager) {
        super(manager);
    }

    public void close() {
        this.endOfGroup = false;
        this.hiddenDetail = false;
        this.needPageBreak = false;
        this.listingExecutor = null;
        super.close();
    }

    void setLisingExecutor(ListingElementExecutor executor) {
        this.listingExecutor = executor;
        this.rset = this.listingExecutor.rset;
    }

    public boolean hasNextChild() {
        if (this.currentElement < this.totalElements) {
            return true;
        }
        if (this.endOfGroup) {
            return false;
        }
        while (!this.endOfGroup) {
            int groupLevel;
            IResultSet rset = this.listingExecutor.getResultSet();
            GroupDesign groupDesign = (GroupDesign)this.getDesign();
            int endGroup = rset.getEndingGroupLevel();
            if (endGroup <= (groupLevel = groupDesign.getGroupLevel() + 1)) {
                this.totalElements = 0;
                this.currentElement = 0;
                BandDesign footer = groupDesign.getFooter();
                if (footer != null) {
                    this.executableElements[this.totalElements++] = footer;
                }
                this.endOfGroup = true;
                return this.currentElement < this.totalElements;
            }
            if (!rset.next()) continue;
            this.listingExecutor.nextRow();
            this.collectExecutableElements();
            if (this.currentElement >= this.totalElements) continue;
            return true;
        }
        return false;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign nextDesign;
            ReportItemExecutor nextExecutor;
            if (!$assertionsDisabled && this.currentElement >= this.totalElements) {
                throw new AssertionError();
            }
            if ((nextExecutor = this.manager.createExecutor(this, nextDesign = this.executableElements[this.currentElement++])) instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)nextExecutor;
                groupExecutor.setLisingExecutor(this.listingExecutor);
            }
            return nextExecutor;
        }
        return null;
    }

    protected void prepareToExecuteChildren() {
        this.collectExecutableElements();
        this.clearDuplicateFlags();
    }

    protected void processSoftPageBreakBefore() {
        CSSValue pageBreak;
        IStyle style;
        if (this.listingExecutor.needSoftBreakBefore() && (style = this.content.getStyle()) != null && ((pageBreak = style.getProperty(46)) == null || IStyle.AUTO_VALUE.equals(pageBreak))) {
            style.setProperty(46, IStyle.SOFT_VALUE);
        }
    }

    void collectExecutableElements() {
        int endGroup;
        BandDesign header;
        this.currentElement = 0;
        this.totalElements = 0;
        this.endOfGroup = false;
        ListingDesign listingDesign = (ListingDesign)this.listingExecutor.getDesign();
        IResultSet rset = this.listingExecutor.getResultSet();
        GroupDesign groupDesign = (GroupDesign)this.getDesign();
        int groupCount = listingDesign.getGroupCount();
        int groupLevel = groupDesign.getGroupLevel() + 1;
        int startGroup = rset.getStartingGroupLevel();
        this.hiddenDetail = groupDesign.getHideDetail();
        if (startGroup <= groupLevel && (header = groupDesign.getHeader()) != null) {
            this.executableElements[this.totalElements++] = header;
        }
        if (!this.hiddenDetail) {
            if (groupCount > groupLevel) {
                this.executableElements[this.totalElements++] = listingDesign.getGroup(groupLevel);
            } else {
                BandDesign detail = listingDesign.getDetail();
                if (detail != null) {
                    this.executableElements[this.totalElements++] = listingDesign.getDetail();
                }
            }
        }
        if ((endGroup = rset.getEndingGroupLevel()) <= groupLevel) {
            BandDesign footer = groupDesign.getFooter();
            if (footer != null) {
                this.executableElements[this.totalElements++] = groupDesign.getFooter();
            }
            if (endGroup <= groupLevel) {
                this.endOfGroup = true;
            }
        }
    }

    protected void handlePageBreakBeforeOfGroup() {
        boolean needPageBreak = false;
        GroupDesign groupDesign = (GroupDesign)this.design;
        if (groupDesign != null) {
            String pageBreakBefore = groupDesign.getPageBreakBefore();
            int groupLevel = groupDesign.getGroupLevel();
            if ("always".equals(pageBreakBefore)) {
                needPageBreak = true;
            }
            if ("always-excluding-first".equals(pageBreakBefore) && this.rset.getStartingGroupLevel() > groupLevel) {
                needPageBreak = true;
            }
            if (needPageBreak) {
                this.content.getStyle().setProperty(46, IStyle.ALWAYS_VALUE);
            }
        }
    }

    protected void handlePageBreakAfterOfGroup() {
        boolean needPageBreak = false;
        GroupDesign groupDesign = (GroupDesign)this.design;
        if (groupDesign != null) {
            String pageBreakAfter = groupDesign.getPageBreakAfter();
            if ("always".equals(pageBreakAfter)) {
                needPageBreak = true;
            }
            if (needPageBreak) {
                this.content.getStyle().setProperty(51, IStyle.ALWAYS_VALUE);
            }
        }
    }

    protected void handlePageBreakAfter() {
    }

    protected void handlePageBreakBefore() {
    }

    protected void handlePageBreakAfterExclusingLast() {
        GroupDesign groupDesign = (GroupDesign)this.design;
        if (groupDesign != null) {
            int endGroup;
            String pageBreakAfter = groupDesign.getPageBreakAfter();
            int groupLevel = groupDesign.getGroupLevel();
            if ("always-excluding-last".equals(pageBreakAfter) && (endGroup = this.rset.getEndingGroupLevel()) >= groupLevel + 1) {
                this.setPageBreakBeforeForNextGroup();
            }
        }
    }

    protected void handlePageBreakAfterOfPreviousGroup() {
        if (this.parent instanceof GroupExecutor) {
            GroupExecutor pGroup = (GroupExecutor)this.parent;
            if (pGroup.needPageBreak) {
                this.content.getStyle().setProperty(46, IStyle.ALWAYS_VALUE);
                pGroup.needPageBreak = false;
            }
        } else if (this.parent instanceof ListingElementExecutor) {
            ListingElementExecutor pList = (ListingElementExecutor)this.parent;
            if (pList.needPageBreak) {
                this.content.getStyle().setProperty(46, IStyle.ALWAYS_VALUE);
                pList.needPageBreak = false;
            }
        }
    }

    protected void setPageBreakBeforeForNextGroup() {
        if (this.parent instanceof GroupExecutor) {
            GroupExecutor pGroup = (GroupExecutor)this.parent;
            pGroup.needPageBreak = true;
        } else if (this.parent instanceof ListingElementExecutor) {
            ListingElementExecutor pList = (ListingElementExecutor)this.parent;
            pList.needPageBreak = true;
        }
    }

    protected void clearDuplicateFlags() {
        GroupDesign groupDesign = (GroupDesign)this.getDesign();
        ListingDesign listingDesign = (ListingDesign)this.listingExecutor.getDesign();
        for (int i = groupDesign.getGroupLevel(); i < listingDesign.getGroupCount(); ++i) {
            GroupDesign group = listingDesign.getGroup(i);
            SuppressDuplicateUtil.clearDuplicateFlags(group);
        }
        SuppressDuplicateUtil.clearDuplicateFlags(listingDesign.getDetail());
    }

    static {
        $assertionsDisabled = !GroupExecutor.class.desiredAssertionStatus();
    }
}

