/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.w3c.dom.css.CSSValue;

public class ListBandExecutor
extends StyledItemExecutor {
    ListingElementExecutor listExecutor;
    int currentItem;

    protected ListBandExecutor(ExecutorManager manager) {
        super(manager);
    }

    void setListingExecutor(ListingElementExecutor listExecutor) {
        this.listExecutor = listExecutor;
    }

    public IContent execute() {
        CSSValue pageBreak;
        IStyle style;
        ListBandDesign bandDesign = (ListBandDesign)this.getDesign();
        IListBandContent bandContent = this.report.createListBandContent();
        this.setContent(bandContent);
        this.restoreResultSet();
        this.initializeContent(bandDesign, bandContent);
        int type = bandDesign.getBandType();
        if ((type == 0 || type == 3) && this.listExecutor.needSoftBreakBefore() && (style = this.content.getStyle()) != null && ((pageBreak = style.getProperty(46)) == null || IStyle.AUTO_VALUE.equals(pageBreak))) {
            style.setProperty(46, IStyle.SOFT_VALUE);
        }
        this.startTOCEntry(bandContent);
        this.currentItem = 0;
        return bandContent;
    }

    public void close() {
        this.finishTOCEntry();
        super.close();
        this.manager.releaseExecutor(11, this);
    }

    public boolean hasNextChild() {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        return this.currentItem < bandDesign.getContentCount();
    }

    public IReportItemExecutor getNextChild() {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        if (this.currentItem < bandDesign.getContentCount()) {
            ReportItemDesign itemDesign = bandDesign.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(this, itemDesign);
            return executor;
        }
        return null;
    }
}

