/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ListBandExecutor;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;

public class ListItemExecutor
extends ListingElementExecutor {
    protected ListItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        ListItemDesign listDesign = (ListItemDesign)this.getDesign();
        IListContent listContent = this.report.createListContent();
        this.setContent(listContent);
        this.executeQuery();
        this.initializeContent(listDesign, listContent);
        this.processAction(listDesign, listContent);
        this.processBookmark(listDesign, listContent);
        this.processStyle(listDesign, listContent);
        this.processVisibility(listDesign, listContent);
        if (this.context.isInFactory()) {
            ListScriptExecutor.handleOnCreate(listContent, this.context);
        }
        this.startTOCEntry(listContent);
        this.prepareToExecuteChildren();
        return listContent;
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
        this.manager.releaseExecutor(3, this);
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor executor = super.getNextChild();
        if (executor instanceof ListBandExecutor) {
            ListBandExecutor bandExecutor = (ListBandExecutor)executor;
            bandExecutor.setListingExecutor(this);
        }
        return executor;
    }
}

