/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension.internal;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.extension.IRowMetaData;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.internal.RowMetaData;

public class RowSet
implements IRowSet {
    protected IResultSet rset;
    protected IRowMetaData metaData;
    protected boolean closed;
    private boolean isOutterResultSet;
    private boolean isFirstRecord = true;

    public RowSet(IResultSet rset) {
        this(rset, false);
    }

    public RowSet(IResultSet rset, boolean isOutterResultSet) {
        this.isOutterResultSet = isOutterResultSet;
        this.closed = false;
        this.rset = rset;
        this.metaData = new IRowMetaData(){

            public int getColumnCount() {
                return 0;
            }

            public String getColumnName(int index) throws BirtException {
                return null;
            }

            public int getColumnType(int index) throws BirtException {
                return -1;
            }
        };
        try {
            if (rset != null) {
                this.metaData = new RowMetaData(rset.getResultMetaData());
            }
        }
        catch (BirtException birtException) {
            // empty catch block
        }
    }

    public DataSetID getID() {
        return this.rset.getID();
    }

    public IRowMetaData getMetaData() {
        return this.metaData;
    }

    public boolean next() {
        if (this.rset != null) {
            if (this.isFirstRecord) {
                this.isFirstRecord = false;
                if (this.isOutterResultSet) {
                    return true;
                }
            }
            return this.rset.next();
        }
        return false;
    }

    public Object evaluate(String expr) {
        if (this.rset != null) {
            return this.rset.evaluate(expr);
        }
        return null;
    }

    public Object evaluate(IBaseExpression expr) {
        if (this.rset != null) {
            return this.rset.evaluate(expr);
        }
        return null;
    }

    public Object getValue(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public Object getValue(String columnName) {
        throw new UnsupportedOperationException();
    }

    public int getEndingGroupLevel() {
        if (this.rset != null) {
            return this.rset.getEndingGroupLevel();
        }
        return 0;
    }

    public int getStartingGroupLevel() {
        if (this.rset != null) {
            return this.rset.getStartingGroupLevel();
        }
        return 0;
    }

    public void close() {
        if (this.isOutterResultSet) {
            return;
        }
        if (!this.closed) {
            this.closed = true;
            if (this.rset != null) {
                this.rset.close();
            }
        }
    }
}

