/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class ReportExecutorWrapper
implements IReportExecutor {
    public static final int EXECUTOR_VERSION_UNKNOWN = -1;
    public static final int EXECUTOR_VERSION_1 = 1;
    public static final int EXECUTOR_VERSION_2 = 2;
    public static final int EXECUTOR_VERSION_3 = 3;
    public static final int EXECUTOR_VERSION_4 = 4;
    protected IReportExecutor executor;

    public IPageContent createPage(long pageNumber, MasterPageDesign pageDesign) {
        IReportItemExecutor executor = this.createPageExecutor(pageNumber, pageDesign);
        IPageContent content = (IPageContent)executor.execute();
        DOMBuilderEmitter emitter = new DOMBuilderEmitter(content);
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            IContent childContent = childExecutor.execute();
            if (childContent != null) {
                ContentEmitterUtil.startContent(childContent, emitter);
            }
            this.executeAll(executor, emitter);
            if (childContent != null) {
                ContentEmitterUtil.endContent(childContent, emitter);
            }
            childExecutor.close();
        }
        executor.close();
        return content;
    }

    protected void executeAll(IReportItemExecutor executor, IContentEmitter emitter) {
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            IContent childContent = childExecutor.execute();
            if (childContent != null) {
                ContentEmitterUtil.startContent(childContent, emitter);
            }
            this.executeAll(executor, emitter);
            if (childContent != null) {
                ContentEmitterUtil.endContent(childContent, emitter);
            }
            childExecutor.close();
        }
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return this.executor.createPageExecutor(pageNumber, pageDesign);
    }

    public IReportContent execute() {
        return this.executor.execute();
    }

    public void close() {
        this.executor.close();
    }

    public IReportItemExecutor getNextChild() {
        return this.executor.getNextChild();
    }

    public boolean hasNextChild() {
        return this.executor.hasNextChild();
    }

    public static int getVersion(IReportDocument document) throws IOException {
        String docVersion = document.getVersion();
        int version = -1;
        if ("1.0.0".equals(docVersion)) {
            version = 1;
        } else if ("1.2.1".equals(docVersion)) {
            version = 2;
        } else if ("2.1.0".equals(docVersion)) {
            version = 3;
        } else if ("2.1.3-2.2RC0".equals(docVersion)) {
            version = 4;
        }
        return version;
    }
}

