/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.AbstractReportExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.InstanceIDComparator;
import org.eclipse.birt.report.engine.internal.document.v4.ReportBodyExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public class ReportletExecutorV4
extends AbstractReportExecutor {
    private Fragment fragment;
    private ReportItemExecutor bodyExecutor;

    public ReportletExecutorV4(ExecutionContext context, long offset) throws IOException {
        super(context);
        this.fragment = this.createFragment(offset);
        this.bodyExecutor = new ReportBodyExecutor(this.manager, this.fragment);
    }

    public void close() {
        this.bodyExecutor.close();
        super.close();
    }

    public IReportItemExecutor getNextChild() {
        return this.bodyExecutor.getNextChild();
    }

    public boolean hasNextChild() {
        return this.bodyExecutor.hasNextChild();
    }

    protected Fragment createFragment(long offset) throws IOException {
        Object[] leftEdge = this.createIndexes(offset);
        Object[] rightEdge = new Object[leftEdge.length + 1];
        System.arraycopy(leftEdge, 0, rightEdge, 0, leftEdge.length);
        rightEdge[leftEdge.length] = Segment.RIGHT_MOST_EDGE;
        Fragment fragment = new Fragment(new InstanceIDComparator());
        fragment.addFragment(leftEdge, rightEdge);
        return fragment;
    }

    protected InstanceIndex[] createIndexes(long offset) throws IOException {
        LinkedList<InstanceIndex> parents = new LinkedList<InstanceIndex>();
        for (IContent content = this.reader.loadContent(offset); content != null; content = (IContent)content.getParent()) {
            InstanceID iid = content.getInstanceID();
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt == null) continue;
            long index = docExt.getIndex();
            parents.addFirst(new InstanceIndex(iid, index));
        }
        InstanceIndex[] edges = new InstanceIndex[parents.size()];
        Iterator iter = parents.iterator();
        int length = 0;
        while (iter.hasNext()) {
            InstanceIndex index = (InstanceIndex)iter.next();
            edges[length++] = index;
        }
        return edges;
    }
}

