/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.RowExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TableItemExecutor;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;

public class TableBandExecutor
extends ContainerExecutor {
    private int nextItem = 0;
    private TableItemExecutor tableExecutor;

    protected TableBandExecutor(ExecutorManager manager) {
        super(manager, 12);
    }

    protected IContent doCreateContent() {
        return this.report.createTableBandContent();
    }

    protected void doExecute() throws Exception {
    }

    public void close() {
        this.nextItem = 0;
        super.close();
    }

    void setTableExecutor(TableItemExecutor tableExecutor) {
        this.tableExecutor = tableExecutor;
    }

    TableItemExecutor getTableExecutor() {
        return this.tableExecutor;
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        int rowCount = bandDesign.getRowCount();
        if (this.nextItem < rowCount) {
            RowDesign rowDesign = bandDesign.getRow(this.nextItem);
            RowExecutor rowExecutor = (RowExecutor)this.manager.createExecutor(this, rowDesign, offset);
            int rowId = this.tableExecutor.getRowId();
            rowExecutor.setRowId(rowId);
            this.tableExecutor.setRowId(rowId++);
            ++this.nextItem;
            return rowExecutor;
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) {
        TableBandDesign bandDesign = (TableBandDesign)this.getDesign();
        int rowCount = bandDesign.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            RowDesign childDesign = bandDesign.getRow(i);
            if (childDesign.getID() != id.getComponentID()) continue;
            this.nextItem = i;
            return;
        }
        this.nextItem = rowCount;
    }
}

