/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dup;

import java.util.LinkedList;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.DataItemExecutionState;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.SuppressDuplicateUtil;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplicateItemExecutor;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class SuppressDuplciateReportExecutor
implements IReportExecutor {
    private IReportContent report;
    private IReportExecutor executor;
    private SuppressDuplicateVisitor visitor;
    private LinkedList executors = new LinkedList();

    public SuppressDuplciateReportExecutor(IReportExecutor executor) {
        this.executor = executor;
        this.visitor = new SuppressDuplicateVisitor();
    }

    public void close() {
        this.executor.close();
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return this.executor.createPageExecutor(pageNumber, pageDesign);
    }

    public IReportContent execute() {
        if (this.report == null) {
            this.report = this.executor.execute();
        }
        return this.report;
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.executor.getNextChild();
        if (childExecutor != null) {
            return this.createExecutor(childExecutor);
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.executor.hasNextChild();
    }

    IReportItemExecutor createExecutor(IReportItemExecutor executor) {
        SuppressDuplicateItemExecutor pooledExecutor = null;
        pooledExecutor = this.executors.isEmpty() ? new SuppressDuplicateItemExecutor(this) : (SuppressDuplicateItemExecutor)this.executors.removeLast();
        pooledExecutor.executor = executor;
        return pooledExecutor;
    }

    void release(IReportItemExecutor executor) {
        this.executors.addLast(executor);
    }

    IContent suppressDuplicate(IContent content) {
        return (IContent)content.accept(this.visitor, content);
    }

    private class SuppressDuplicateVisitor
    extends ContentVisitorAdapter {
        private SuppressDuplicateVisitor() {
        }

        public Object visitContent(IContent content, Object param) {
            return content;
        }

        public Object visitData(IDataContent data, Object param) {
            DataItemDesign dataDesign;
            IDataContent dataContent = data;
            Object genBy = dataContent.getGenerateBy();
            if (genBy instanceof DataItemDesign && (dataDesign = (DataItemDesign)genBy).getSuppressDuplicate()) {
                Object lastValue;
                Object value = dataContent.getValue();
                DataItemExecutionState state = (DataItemExecutionState)dataDesign.getExecutionState();
                if (state != null && ((lastValue = state.lastValue) == value || lastValue != null && lastValue.equals(value))) {
                    return null;
                }
                if (state == null) {
                    state = new DataItemExecutionState();
                    dataDesign.setExecutionState(state);
                }
                state.lastValue = value;
            }
            return data;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            Object genBy = group.getGenerateBy();
            if (genBy instanceof GroupDesign) {
                this.clearDuplicateFlags((GroupDesign)genBy);
            }
            return group;
        }

        public Object visitList(IListContent list, Object value) {
            Object genBy = list.getGenerateBy();
            if (genBy instanceof ListingDesign) {
                this.clearDuplicateFlags((ListingDesign)genBy);
            }
            return list;
        }

        public Object visitTable(ITableContent table, Object value) {
            Object genBy = table.getGenerateBy();
            if (genBy instanceof ListingDesign) {
                this.clearDuplicateFlags((ListingDesign)genBy);
            }
            return table;
        }

        protected void clearDuplicateFlags(ListingDesign listingDesign) {
            SuppressDuplicateUtil.clearDuplicateFlags(listingDesign);
        }

        protected void clearDuplicateFlags(GroupDesign groupDesign) {
            ListingDesign listingDesign = this.getListingDesign(groupDesign);
            int groupLevel = groupDesign.getGroupLevel();
            int groupCount = listingDesign.getGroupCount();
            for (int i = groupLevel; i < groupCount; ++i) {
                GroupDesign group = listingDesign.getGroup(i);
                SuppressDuplicateUtil.clearDuplicateFlags(group);
            }
            SuppressDuplicateUtil.clearDuplicateFlags(listingDesign.getDetail());
        }

        protected ListingDesign getListingDesign(GroupDesign groupDesign) {
            long listingId = groupDesign.getHandle().getContainer().getID();
            return (ListingDesign)SuppressDuplciateReportExecutor.this.report.getDesign().getReportItemByID(listingId);
        }
    }
}

