/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.l18n;

import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportItemExecutorManager;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor;

public class LocalizedReportExecutor
implements IReportExecutor {
    IReportExecutor executor;
    LocalizedContentVisitor l18nVisitor;
    LocalizedReportItemExecutorManager manager;

    public LocalizedReportExecutor(ExecutionContext context, IReportExecutor executor) {
        this.l18nVisitor = new LocalizedContentVisitor(context);
        this.manager = new LocalizedReportItemExecutorManager(this.l18nVisitor);
        this.executor = executor;
    }

    public void close() {
        this.executor.close();
    }

    public IReportContent execute() {
        return this.executor.execute();
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.executor.getNextChild();
        if (childExecutor != null) {
            return this.manager.createExecutor(childExecutor);
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.executor.hasNextChild();
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        IReportItemExecutor pageExecutor = this.executor.createPageExecutor(pageNumber, pageDesign);
        if (pageExecutor != null) {
            return this.manager.createExecutor(pageExecutor);
        }
        return null;
    }
}

