/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.parser.HTMLTextParser;
import org.eclipse.birt.report.engine.parser.PlainTextParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TextParser {
    public static String TEXT_TYPE_AUTO;
    public static String TEXT_TYPE_PLAIN;
    public static String TEXT_TYPE_HTML;
    public static String TEXT_TYPE_RTF;
    public static String HTML_PREFIX;
    public static String RTF_PREFIX;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Document parse(String text, String textType) {
        if (text == null || text.length() == 0) {
            return null;
        }
        if (null == textType || TEXT_TYPE_AUTO.equalsIgnoreCase(textType)) {
            int index;
            int len = text.length();
            for (index = 0; index < len && Character.isWhitespace(text.charAt(index)); ++index) {
            }
            textType = len - index >= 6 && text.substring(index, index + 6).equalsIgnoreCase(HTML_PREFIX) ? TEXT_TYPE_HTML : (len - index >= 4 && text.substring(index, index + 4).equalsIgnoreCase(RTF_PREFIX) ? TEXT_TYPE_RTF : TEXT_TYPE_PLAIN);
        }
        Document doc = null;
        if (TEXT_TYPE_HTML.equalsIgnoreCase(textType)) {
            try {
                doc = new HTMLTextParser().parseHTML(new ByteArrayInputStream(text.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        } else {
            if (TEXT_TYPE_RTF.equalsIgnoreCase(textType)) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            if (!TEXT_TYPE_PLAIN.equalsIgnoreCase(textType)) {
                logger.log(Level.WARNING, "Invalid text type. The content is treated as plain text.");
            }
            doc = new PlainTextParser().parsePlainText(text);
        }
        if (doc != null && doc.getFirstChild() != null && doc.getFirstChild() instanceof Element) {
            ((Element)doc.getFirstChild()).setAttribute("text-type", textType);
        }
        return doc;
    }

    public Document parse(InputStream in, String textType) {
        if (in == null) {
            return null;
        }
        InputStream tmpInputStream = in;
        if (null == textType || TEXT_TYPE_AUTO.equalsIgnoreCase(textType)) {
            StringBuffer buf = new StringBuffer();
            try {
                int chr;
                while ((chr = in.read()) != -1 && Character.isWhitespace((char)chr)) {
                    buf.append((char)chr);
                }
                for (int headLen = 0; headLen < 6 && chr != -1; ++headLen) {
                    buf.append((char)chr);
                    chr = in.read();
                }
                textType = buf.toString().toLowerCase().endsWith(HTML_PREFIX) ? TEXT_TYPE_HTML : (buf.toString().toLowerCase().endsWith(RTF_PREFIX) ? TEXT_TYPE_RTF : TEXT_TYPE_PLAIN);
                if (chr != -1) {
                    buf.append((char)chr);
                }
                byte[] head = buf.toString().getBytes();
                PushbackInputStream pin = new PushbackInputStream(in, head.length);
                pin.unread(head, 0, head.length);
                tmpInputStream = pin;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        Document doc = null;
        if (TEXT_TYPE_HTML.equalsIgnoreCase(textType)) {
            doc = new HTMLTextParser().parseHTML(tmpInputStream);
        } else {
            if (TEXT_TYPE_RTF.equals(textType)) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            if (!TEXT_TYPE_PLAIN.equalsIgnoreCase(textType)) {
                logger.log(Level.WARNING, "Invalid text type. The content is treated as plain text.");
            }
            doc = new PlainTextParser().parsePlainText(tmpInputStream);
        }
        if (doc != null && doc.getFirstChild() != null && doc.getFirstChild() instanceof Element) {
            ((Element)doc.getFirstChild()).setAttribute("text-type", textType);
        }
        return doc;
    }

    static {
        $assertionsDisabled = !TextParser.class.desiredAssertionStatus();
        TEXT_TYPE_AUTO = "auto";
        TEXT_TYPE_PLAIN = "plain";
        TEXT_TYPE_HTML = "html";
        TEXT_TYPE_RTF = "rtf";
        HTML_PREFIX = "<html>";
        RTF_PREFIX = "\\rtf";
        logger = Logger.getLogger(TextParser.class.getName());
    }
}

