/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.ISortCondition;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;

public class SortConditionImpl
implements ISortCondition {
    private SortKeyHandle sort;
    private DesignElementHandle handle;

    public SortConditionImpl(SortKeyHandle sort, DesignElementHandle handle) {
        this.handle = handle;
        this.sort = sort;
    }

    public String getDirection() {
        return this.sort.getDirection();
    }

    public String getKey() {
        return this.sort.getKey();
    }

    public void setDirection(String direction) throws ScriptException {
        this.checkHandle();
        try {
            this.sort.setDirection(direction);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setKey(String key) throws ScriptException {
        this.checkKey(key);
        try {
            this.sort.setKey(key);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    private void checkHandle() throws ScriptException {
        if (this.sort != null) {
            return;
        }
        throw new ScriptException("SortKeyHandle is null ");
    }

    private void checkKey(String key) throws ScriptException {
        if (this.sort != null) {
            return;
        }
        SortKey c = new SortKey();
        c.setKey(key);
        if (this.handle instanceof ListGroupHandle) {
            PropertyHandle propHandle = this.handle.getPropertyHandle("sort");
            try {
                this.sort = (SortKeyHandle)propHandle.addItem((IStructure)c);
            }
            catch (SemanticException e) {
                throw new ScriptException(e.getLocalizedMessage());
            }
        }
        if (this.handle instanceof ListingHandle) {
            PropertyHandle propHandle = this.handle.getPropertyHandle("sort");
            try {
                this.sort = (SortKeyHandle)propHandle.addItem((IStructure)c);
            }
            catch (SemanticException e) {
                throw new ScriptException(e.getLocalizedMessage());
            }
        }
    }
}

