/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExportManifestUtils {
    static final String[] API_JAR_PATTERNS = new String[]{"chartengineapi.jar", "com.ibm.icu.*.jar", "commons-codec-.*.jar", "coreapi.jar", "dataadapterapi.jar", "dteapi.jar", "engineapi.jar", "flute.jar", "js.jar", "modelapi.jar", "org.eclipse.emf.common_.*.jar", "org.eclipse.emf.ecore.xmi_.*.jar", "org.eclipse.emf.ecore_.*.jar", "sac.jar", "scriptapi.jar", "modelodaapi.jar", "dtpdesign.jar"};

    public static void main(String[] args) throws IOException {
        String jarFolder = "c:/birt-runtime-2_1_2/birt/WEB-INF/lib";
        if (args.length > 0) {
            jarFolder = args[0];
        }
        File[] jarFiles = new File(jarFolder).listFiles();
        for (int i = 0; i < jarFiles.length; ++i) {
            if (!ExportManifestUtils.isApiJar(jarFiles[i])) continue;
            ExportManifestUtils.exportPackages(jarFiles[i]);
        }
    }

    static boolean isApiJar(File jarFile) {
        String name = jarFile.getName();
        for (int i = 0; i < API_JAR_PATTERNS.length; ++i) {
            if (!name.matches(API_JAR_PATTERNS[i])) continue;
            return true;
        }
        return false;
    }

    static void exportPackages(File jarFile) throws IOException {
        System.out.println("#" + jarFile.getName());
        JarFile jar = new JarFile(jarFile);
        Entry root = new Entry();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ExportManifestUtils.createEntry(root, entry);
        }
        for (int i = 0; i < root.children.size(); ++i) {
            ExportManifestUtils.outputEntry((Entry)root.children.get(i), "");
        }
    }

    static void outputEntry(Entry entry, String prefix) {
        if (entry.hasFiles) {
            System.out.println(" " + prefix + "." + entry.name + ",");
        }
        prefix = prefix != null && prefix.length() != 0 ? prefix + "." + entry.name : entry.name;
        for (int i = 0; i < entry.children.size(); ++i) {
            ExportManifestUtils.outputEntry((Entry)entry.children.get(i), prefix);
        }
    }

    static void createEntry(Entry root, JarEntry entry) {
        if (entry.isDirectory()) {
            String name = entry.getName();
            String[] names = name.split("/");
            for (int i = 0; i < names.length; ++i) {
                root = ExportManifestUtils.createEntry(root, names[i]);
            }
        } else {
            String name = entry.getName();
            String[] names = name.split("/");
            for (int i = 0; i < names.length - 1; ++i) {
                root = ExportManifestUtils.createEntry(root, names[i]);
            }
            root.hasFiles = true;
        }
    }

    static Entry createEntry(Entry parent, String name) {
        for (int i = 0; i < parent.children.size(); ++i) {
            Entry entry = (Entry)parent.children.get(i);
            if (!name.equals(entry.name)) continue;
            return entry;
        }
        Entry entry = new Entry();
        entry.name = name;
        parent.children.add(entry);
        return entry;
    }

    static class Entry {
        String name;
        boolean hasFiles;
        ArrayList children = new ArrayList();

        Entry() {
        }
    }
}

