/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.text.Bidi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;

public class SQLUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveDataSetDesign(DataSetDesign design) {
        IConnection conn = null;
        OdaJdbcDriver jdbcDriver = new OdaJdbcDriver();
        conn = jdbcDriver.getConnection(null);
        Properties prop = new Properties();
        DataSourceDesign dataSourceDesign = design.getDataSourceDesign();
        if (dataSourceDesign != null) {
            prop.put("odaDriverClass", dataSourceDesign.getPublicProperties().getProperty("odaDriverClass") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaDriverClass"));
            prop.put("odaURL", dataSourceDesign.getPublicProperties().getProperty("odaURL") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaURL"));
            prop.put("odaUser", dataSourceDesign.getPublicProperties().getProperty("odaUser") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaUser"));
            prop.put("odaPassword", dataSourceDesign.getPublicProperties().getProperty("odaPassword") == null ? "" : dataSourceDesign.getPublicProperties().getProperty("odaPassword"));
        }
        conn.open(prop);
        IQuery query = conn.newQuery(design.getOdaExtensionDataSetId());
        query.setMaxRows(1);
        query.prepare(design.getQueryText());
        SQLUtility.setParameterMetaData(design, query);
        IResultSetMetaData metadata = query.getMetaData();
        SQLUtility.setResultSetMetaData(design, metadata);
        Object var8_8 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (OdaException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (OdaException e) {
                design.setResultSets(null);
                Object var8_9 = null;
                if (conn == null) return;
                try {
                    conn.close();
                    return;
                }
                catch (OdaException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (OdaException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    private static void setParameterMetaData(DataSetDesign dataSetDesign, IQuery query) {
        try {
            IParameterMetaData paramMetaData = query.getParameterMetaData();
            SQLUtility.mergeParameterMetaData(dataSetDesign, paramMetaData);
        }
        catch (OdaException e) {
            dataSetDesign.setParameters(null);
        }
    }

    public static int[] getBidiLineSegments(String lineText) {
        int[] seg = null;
        if (lineText != null && lineText.length() > 0 && !new Bidi(lineText, 0).isLeftToRight()) {
            int i;
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] splits = lineText.split("\\p{Punct}");
            for (i = 0; i < splits.length; ++i) {
                if (splits[i].equals("")) continue;
                list.add(splits[i]);
            }
            splits = list.toArray();
            seg = new int[splits.length + 1];
            for (i = 0; i < splits.length; ++i) {
                seg[i + 1] = lineText.indexOf((String)splits[i], seg[i]) + ((String)splits[i]).length();
            }
        }
        return seg;
    }

    public static String getQueryPresetTextString(String extensionId) {
        String[] lines = SQLUtility.getQueryPresetTextArray(extensionId);
        String result = "";
        if (lines != null && lines.length > 0) {
            for (int i = 0; i < lines.length; ++i) {
                result = result + lines[i] + (i == lines.length - 1 ? " " : " \n");
            }
        }
        return result;
    }

    public static String[] getQueryPresetTextArray(String extensionId) {
        String[] lines = extensionId.equals("org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet") ? new String[]{"{call procedure-name(arg1,arg2, ...)}"} : new String[]{"select", "from"};
        return lines;
    }

    public static String getTailoredSearchText(String namePattern) {
        if (namePattern != null) {
            if (namePattern.lastIndexOf(37) == -1) {
                namePattern = namePattern + "%";
            }
        } else {
            namePattern = "%";
        }
        return namePattern;
    }

    public static Object getDnDString(Object obj, String identifierStr, boolean useIdentifier) {
        if (!useIdentifier || !(obj instanceof String)) {
            return obj;
        }
        String identifierQuoteString = identifierStr;
        String dndString = (String)obj;
        if (!identifierQuoteString.equals(" ")) {
            if (dndString.indexOf(".") == -1) {
                return identifierQuoteString + dndString + identifierQuoteString;
            }
            String[] str = dndString.split("[.]");
            dndString = "";
            for (int i = 0; i < str.length; ++i) {
                dndString = dndString + identifierQuoteString + str[i] + identifierQuoteString + ".";
            }
            return dndString.substring(0, dndString.lastIndexOf("."));
        }
        return dndString;
    }

    private static void mergeParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData md) throws OdaException {
        if (md == null || dataSetDesign == null) {
            return;
        }
        DataSetParameters dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)md, (ParameterMode)ParameterMode.IN_LITERAL);
        if (dataSetParameter != null) {
            Iterator iter = dataSetParameter.getParameterDefinitions().iterator();
            while (iter.hasNext()) {
                ParameterDefinition defn = (ParameterDefinition)iter.next();
                SQLUtility.proccessParamDefn(defn, dataSetParameter);
            }
        }
        dataSetDesign.setParameters(dataSetParameter);
    }

    private static void proccessParamDefn(ParameterDefinition defn, DataSetParameters parameters) {
        if (defn.getAttributes().getNativeDataTypeCode() == 0) {
            defn.getAttributes().setNativeDataTypeCode(1);
        }
    }

    private static void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        if (columns != null) {
            ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            resultSetDefn.setResultSetColumns(columns);
            dataSetDesign.setPrimaryResultSet(resultSetDefn);
            dataSetDesign.getResultSets().setDerivedMetaData(true);
        } else {
            dataSetDesign.setResultSets(null);
        }
    }
}

