/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.provider;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.IMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Column;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverLoader;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Procedure;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ProcedureParameter;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class JdbcMetaDataProvider
implements IMetaDataProvider {
    private Connection jdbcConnection = null;
    private String userName = null;
    private String url = null;
    private String driverClass = null;
    private String pass = null;
    private DatabaseMetaData metaData;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JdbcMetaDataProvider(Connection connection) {
        this.jdbcConnection = connection;
        this.metaData = null;
    }

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public void setJdbcConnection(Connection jdbcConnection) {
        this.jdbcConnection = jdbcConnection;
    }

    public Connection connect(String userName, String password, String url, String driverClass, String odaDriverName) {
        if (url == null || driverClass == null) {
            return null;
        }
        if (!((userName == null || userName.equals(this.userName)) && url.equals(this.url) && driverClass.equals(this.driverClass) || this.jdbcConnection == null)) {
            this.closeConnection();
            this.jdbcConnection = null;
            this.metaData = null;
        }
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = DriverLoader.getConnection(driverClass, url, userName, password);
                if (this.jdbcConnection == null) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)JdbcPlugin.getResourceString("connection.test"), (String)JdbcPlugin.getResourceString("connection.failed"));
                } else {
                    this.driverClass = driverClass;
                    this.url = url;
                    this.userName = userName;
                    this.pass = password;
                }
            }
            catch (SQLException e) {
                ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
                return null;
            }
        }
        return this.jdbcConnection;
    }

    public Connection connect(DataSourceDesign dataSourceHandle) {
        DataSourceDesign handle = dataSourceHandle;
        String userName = handle.getPublicProperties().findProperty("odaUser").getValue();
        String passWord = handle.getPublicProperties().findProperty("odaPassword").getValue();
        String url = handle.getPublicProperties().findProperty("odaURL").getValue();
        String driver = handle.getPublicProperties().findProperty("odaDriverClass").getValue();
        this.jdbcConnection = this.connect(userName, passWord, url, driver, handle.getOdaExtensionId());
        return this.jdbcConnection;
    }

    public Connection getConnection() {
        return this.jdbcConnection;
    }

    public void closeConnection() {
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.isClosed()) {
                    this.jdbcConnection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getDataBaseName() {
        if (this.jdbcConnection == null) {
            return "";
        }
        if (this.metaData == null) {
            try {
                this.metaData = this.jdbcConnection.getMetaData();
            }
            catch (SQLException e) {
                ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
            }
        }
        if (this.metaData == null) {
            return "";
        }
        String databaseName = "";
        try {
            databaseName = this.metaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (databaseName == null) {
            databaseName = "";
        }
        return databaseName;
    }

    public DatabaseMetaData getMetaData() {
        if (this.jdbcConnection == null) {
            return null;
        }
        if (this.metaData == null) {
            try {
                this.metaData = this.jdbcConnection.getMetaData();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.metaData;
    }

    public ResultSet getAllSchema() {
        if (!$assertionsDisabled && this.jdbcConnection == null) {
            throw new AssertionError();
        }
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        ResultSet schemaRs = null;
        try {
            schemaRs = this.metaData.getSchemas();
        }
        catch (SQLException e) {
            try {
                schemaRs = this.reTryAchieveResultSet("SCHEMAS", null);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return schemaRs;
    }

    public boolean isSchemaSupported() {
        DatabaseMetaData metaData = this.getMetaData();
        try {
            if (metaData != null) {
                return metaData.supportsSchemasInTableDefinitions();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public ResultSet getAlltables(String cataLog, String schemaPattern, String namePattern, String[] types) {
        if (this.jdbcConnection == null) {
            return null;
        }
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        ResultSet resultSet = null;
        if (cataLog != null && cataLog.trim().length() == 0) {
            cataLog = null;
        }
        if (this.metaData != null) {
            try {
                resultSet = this.metaData.getTables(cataLog, schemaPattern, namePattern, types);
            }
            catch (SQLException e) {
                try {
                    return this.reTryAchieveResultSet("TABLES", new Object[]{cataLog, schemaPattern, namePattern, types});
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return resultSet;
    }

    public ArrayList getAllProcedure(String cataLog, String schemaPattern, String namePattern) {
        ArrayList<Procedure> procedureList = new ArrayList<Procedure>();
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        ResultSet procedureRs = null;
        if (cataLog != null && cataLog.trim().length() == 0) {
            cataLog = null;
        }
        if (this.metaData != null) {
            try {
                try {
                    procedureRs = this.metaData.getProcedures(cataLog, schemaPattern, namePattern);
                }
                catch (SQLException e) {
                    procedureRs = this.reTryAchieveResultSet("PROCEDURE", new Object[]{cataLog, schemaPattern, namePattern});
                }
                while (procedureRs.next()) {
                    boolean isSame = false;
                    Procedure procedure = new Procedure();
                    procedure.setCatalog(procedureRs.getString("PROCEDURE_CAT"));
                    procedure.setSchema(procedureRs.getString("PROCEDURE_SCHEM"));
                    procedure.setProcedureName(procedureRs.getString("PROCEDURE_NAME"));
                    for (int i = 0; i < procedureList.size(); ++i) {
                        if (!((Procedure)procedureList.get(i)).isEqualWith(procedure)) continue;
                        isSame = true;
                    }
                    if (isSame) continue;
                    procedureList.add(procedure);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return procedureList;
    }

    public ArrayList getProcedureColumns(String cataLog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        ArrayList<ProcedureParameter> columnList = new ArrayList<ProcedureParameter>();
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        ResultSet columnsRs = null;
        if (cataLog != null && cataLog.trim().length() == 0) {
            cataLog = null;
        }
        if (this.metaData != null) {
            try {
                try {
                    columnsRs = this.metaData.getProcedureColumns(cataLog, schemaPattern, procedureNamePattern, columnNamePattern);
                }
                catch (SQLException e) {
                    columnsRs = this.reTryAchieveResultSet("PROCEDURE_COLUMNS", new Object[]{cataLog, schemaPattern, procedureNamePattern, columnNamePattern});
                }
                int n = 0;
                while (columnsRs.next()) {
                    ProcedureParameter column = new ProcedureParameter();
                    column.setSchema(schemaPattern);
                    column.setProcedureName(columnsRs.getString("PROCEDURE_NAME"));
                    String columnName = columnsRs.getString("COLUMN_NAME");
                    if (columnName != null) {
                        column.setName(columnName);
                    } else {
                        column.setName("param" + ++n);
                    }
                    column.setModeType(columnsRs.getInt("COLUMN_TYPE"));
                    column.setDataType(columnsRs.getInt("DATA_TYPE"));
                    column.setDataTypeName(columnsRs.getString("TYPE_NAME"));
                    columnList.add(column);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return columnList;
    }

    public boolean isProcedureSupported() {
        this.metaData = this.getMetaData();
        try {
            if (this.metaData != null) {
                return this.metaData.supportsStoredProcedures();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public ArrayList getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        try {
            ResultSet columnsRs = null;
            try {
                columnsRs = this.metaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            catch (SQLException e) {
                columnsRs = this.reTryAchieveResultSet("TABLE_COLUMNS", new Object[]{catalog, schemaPattern, tableNamePattern, columnNamePattern});
            }
            while (columnsRs.next()) {
                Column column = new Column();
                column.setSchemaName(columnsRs.getString("TABLE_SCHEM"));
                column.setTableName(columnsRs.getString("TABLE_NAME"));
                column.setName(columnsRs.getString("COLUMN_NAME"));
                column.setDbType(columnsRs.getString("TYPE_NAME"));
                columnList.add(column);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return columnList;
    }

    private void resetMetadata() throws SQLException {
        this.jdbcConnection = DriverLoader.getConnection(this.driverClass, this.url, this.userName, this.pass);
        this.metaData = this.jdbcConnection.getMetaData();
    }

    public String getCatalog() {
        String cataLog = null;
        if (this.jdbcConnection != null) {
            try {
                cataLog = this.jdbcConnection.getCatalog();
            }
            catch (SQLException e) {
                try {
                    this.closeConnection();
                    this.resetMetadata();
                    cataLog = this.jdbcConnection.getCatalog();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return cataLog;
    }

    public String getCatalogSeparator() {
        if (this.metaData == null) {
            this.metaData = this.getMetaData();
        }
        try {
            String separator = this.metaData.getCatalogSeparator();
            if (separator == null || separator.trim().length() == 0) {
                separator = ".";
            }
            return separator;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ResultSet reTryAchieveResultSet(String name, Object[] arguments) throws SQLException {
        this.closeConnection();
        this.resetMetadata();
        if (name.equalsIgnoreCase("SCHEMAS")) {
            return this.metaData.getSchemas();
        }
        if (name.equalsIgnoreCase("TABLES")) {
            return this.metaData.getTables(String.valueOf(arguments[0]), String.valueOf(arguments[1]), String.valueOf(arguments[2]), arguments[3] == null ? null : (String[])arguments[3]);
        }
        if (name.equalsIgnoreCase("PROCEDURE")) {
            return this.metaData.getProcedures(String.valueOf(arguments[0]), String.valueOf(arguments[1]), String.valueOf(arguments[2]));
        }
        if (name.equalsIgnoreCase("PROCEDURE_COLUMNS")) {
            return this.metaData.getProcedureColumns(String.valueOf(arguments[0]), String.valueOf(arguments[1]), String.valueOf(arguments[2]), String.valueOf(arguments[3]));
        }
        if (name.equalsIgnoreCase("TABLE_COLUMNS")) {
            return this.metaData.getColumns(String.valueOf(arguments[0]), String.valueOf(arguments[1]), String.valueOf(arguments[2]), String.valueOf(arguments[3]));
        }
        if (name.equalsIgnoreCase("CROSSREFERENCE")) {
            return this.metaData.getCrossReference(String.valueOf(arguments[0]), String.valueOf(arguments[1]), String.valueOf(arguments[2]), String.valueOf(arguments[3]), String.valueOf(arguments[4]), String.valueOf(arguments[5]));
        }
        return null;
    }

    static {
        $assertionsDisabled = !JdbcMetaDataProvider.class.desiredAssertionStatus();
    }
}

