/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.util.ArrayList;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JDBCDriverInformation;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class JDBCDriverInfoManager {
    private JDBCDriverInfoManager() {
    }

    public static JDBCDriverInformation[] getDrivers() {
        ArrayList<JDBCDriverInformation> drivers = new ArrayList<JDBCDriverInformation>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.data.oda.jdbc.driverinfo");
        if (configElements != null) {
            for (int e = 0; e < configElements.length; ++e) {
                if (!configElements[e].getName().equals("jdbcDriver")) continue;
                drivers.add(JDBCDriverInfoManager.newJdbcDriverInfo(configElements[e]));
            }
        }
        return drivers.toArray(new JDBCDriverInformation[0]);
    }

    private static JDBCDriverInformation newJdbcDriverInfo(IConfigurationElement configElement) {
        JDBCDriverInformation driverInfo = JDBCDriverInformation.newInstance(configElement.getAttribute("driverClass"));
        driverInfo.setDisplayName(configElement.getAttribute("name"));
        driverInfo.setUrlFormat(configElement.getAttribute("urlTemplate"));
        return driverInfo;
    }
}

