/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.layout;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ReportViewerKeyHandler;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.ModelEventManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddStyleAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ChangeDataColumnPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CopyPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreatePlaceHolderPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CutPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteColumnAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteListGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteRowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteTableGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.EditBindingAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ImportCSSStylePartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeDetailAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeFooterAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.IncludeHeaderAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertListGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertTableGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.MergeAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.PastePartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.RevertToReportItemPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.RevertToTemplatePartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectColumnAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectRowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.UseLibraryPartAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GraphicalPartFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportRootEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.providers.SchematicContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportFlyoutPalettePreferences;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportTemplateTransferDropTargetListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewTreeViewerPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetPage;
import org.eclipse.birt.report.designer.ui.actions.ApplyStyleMenuAction;
import org.eclipse.birt.report.designer.ui.actions.ApplyThemeMenuAction;
import org.eclipse.birt.report.designer.ui.actions.DeleteStyleMenuAction;
import org.eclipse.birt.report.designer.ui.actions.EditGroupMenuAction;
import org.eclipse.birt.report.designer.ui.actions.EditStyleMenuAction;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertExpressionMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertGroupMenuAction;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction;
import org.eclipse.birt.report.designer.ui.actions.NewParameterAction;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class ReportEditorWithPalette
extends GraphicalEditorWithFlyoutPalette
implements IColleague {
    protected PaletteRoot paletteRoot;
    private EditPartFactory editPartFactoy;
    private ModuleHandle model;
    private ModelEventManager manager = this.createModelEventManager();
    private FileReportProvider provider;
    private static final String DLG_ERROR_OPEN_ERROR_MSG = "Can't open file";

    public ReportEditorWithPalette() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public ReportEditorWithPalette(IEditorPart parent) {
        this();
    }

    protected ModelEventManager createModelEventManager() {
        return new ModelEventManager();
    }

    protected ModelEventManager getModelEventManager() {
        return this.manager;
    }

    protected abstract PaletteRoot getPaletteRoot();

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new ReportFlyoutPalettePreferences();
    }

    protected void createActions() {
        super.createActions();
        MergeAction action = new MergeAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SplitAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteRowAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteColumnAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteTableGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertRowAboveAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertRowBelowAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertTableGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertColumnRightAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertColumnLeftAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CutPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PastePartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertListGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteListGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AddStyleAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ImportCSSStylePartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AddGroupAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertGroupMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ChangeDataColumnPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CreatePlaceHolderPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RevertToReportItemPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RevertToTemplatePartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ApplyStyleMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ApplyThemeMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditStyleMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DeleteStyleMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditGroupMenuAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EditBindingAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Text", "Text");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Label", "Label");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Data", "Data");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Grid", "Grid");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert List", "List");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Table", "Table");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Image", "Image");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new GeneralInsertMenuAction((IWorkbenchPart)this, "Insert Dynamic Text", "TextData");
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new NewParameterAction("org.eclipse.birt.report.designer.ui.actions.newScalarParameter", "ScalarParameter");
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new NewParameterAction("org.eclipse.birt.report.designer.ui.actions.newParameterGroup", "ParameterGroup");
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new NewParameterAction("org.eclipse.birt.report.designer.ui.actions.newCascadingParameterGroup", "CascadingParameterGroup");
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new InsertExpressionMenuAction((IWorkbenchPart)this);
        this.getSelectionActions().add(action.getId());
        this.addEditPartAction((SelectionAction)action);
        action = new NewDataSourceAction();
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new NewDataSetAction();
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new DirectEditAction((IWorkbenchPart)this);
        ((DirectEditAction)action).setDirectEditRequest(new Request((Object)"open"));
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncludeHeaderAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncludeDetailAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new IncludeFooterAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UseLibraryPartAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SelectRowAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SelectColumnAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.registerInsertExtElementActions();
    }

    private void registerInsertExtElementActions() {
        List points = ExtensionPointManager.getInstance().getExtendedElementPoints();
        Iterator iter = points.iterator();
        while (iter.hasNext()) {
            ExtendedElementUIPoint point = (ExtendedElementUIPoint)iter.next();
            if (!((Boolean)point.getAttribute("showInDesigner")).booleanValue()) continue;
            GeneralInsertMenuAction action = new GeneralInsertMenuAction((IWorkbenchPart)this, point.getExtensionName(), point.getExtensionName(), point.getExtensionName());
            this.getSelectionActions().add(action.getId());
            this.addEditPartAction((SelectionAction)action);
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (this.getModel() != null) {
            this.setContents();
            this.hookModelEventManager(this.getModel());
        }
        viewer.addDropTargetListener((TransferDropTargetListener)this.createTemplateTransferDropTargetListener((EditPartViewer)viewer));
    }

    protected void setContents() {
        this.getGraphicalViewer().setContents((Object)this.getModel());
    }

    protected void hookModelEventManager(Object model) {
        this.manager.hookRoot(model);
        Object processor = this.getGraphicalViewer().getRootEditPart().getAdapter(IModelEventProcessor.class);
        if (processor instanceof IModelEventProcessor) {
            this.manager.addModelEventProcessor((IModelEventProcessor)processor);
        }
        if (this.getCommandStack() instanceof WrapperCommandStack) {
            this.manager.hookCommandStack((WrapperCommandStack)this.getCommandStack());
        }
    }

    protected void unhookModelEventManager(Object model) {
        this.manager.unhookRoot(model);
        if (this.getCommandStack() instanceof WrapperCommandStack) {
            this.manager.unhookCommandStack((WrapperCommandStack)this.getCommandStack());
        }
    }

    protected TemplateTransferDropTargetListener createTemplateTransferDropTargetListener(EditPartViewer viewer) {
        return new ReportTemplateTransferDropTargetListener(viewer);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        ActionRegistry actionRegistry = this.getActionRegistry();
        ReportRootEditPart root = new ReportRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        this.hookZoom((ScalableFreeformRootEditPart)root);
        viewer.setKeyHandler((KeyHandler)new ReportViewerKeyHandler(viewer, actionRegistry));
        SchematicContextMenuProvider provider = new SchematicContextMenuProvider((EditPartViewer)viewer, actionRegistry);
        viewer.setContextMenu((MenuManager)provider);
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setEditPartFactory(this.getEditPartFactory());
        WrapperCommandStack commandStack = new WrapperCommandStack();
        viewer.getEditDomain().setCommandStack((CommandStack)commandStack);
    }

    protected EditPartFactory getEditPartFactory() {
        if (this.editPartFactoy == null) {
            this.editPartFactoy = new GraphicalPartFactory();
        }
        return this.editPartFactoy;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (this.getModel() == null) {
            throw new PartInitException(DLG_ERROR_OPEN_ERROR_MSG);
        }
    }

    protected ModuleHandle getModel() {
        if (this.model == null) {
            IReportProvider reportProvider = this.getProvider();
            this.model = reportProvider.getReportModuleHandle((Object)this.getEditorInput());
        }
        return this.model;
    }

    protected void setModel(ModuleHandle model) {
        this.model = model;
    }

    public boolean isDirty() {
        if (this.getModel() == null) {
            return false;
        }
        return this.getModel().needsSave();
    }

    public void doSave(IProgressMonitor monitor) {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            provider.saveReport(this.getModel(), (Object)this.getEditorInput(), monitor);
            this.firePropertyChange(257);
        }
    }

    protected IReportProvider getProvider() {
        if (this.provider == null) {
            this.provider = new FileReportProvider();
        }
        return this.provider;
    }

    public void doSaveAs() {
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            IPath path = provider.getSaveAsPath((Object)this.getEditorInput());
            if (path == null) {
                return;
            }
            final IEditorInput input = provider.createNewEditorInput(path);
            this.setInput(input);
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    InvocationTargetException[] iteHolder = new InvocationTargetException[1];
                    try {
                        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(this, iteHolder){
                            private final /* synthetic */ InvocationTargetException[] val$iteHolder;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$iteHolder = val$iteHolder;
                            }

                            public void run(IProgressMonitor pm) throws CoreException {
                                try {
                                    this.this$1.execute(pm);
                                }
                                catch (InvocationTargetException e) {
                                    this.val$iteHolder[0] = e;
                                }
                                catch (InterruptedException e) {
                                    throw new OperationCanceledException(e.getMessage());
                                }
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                    if (iteHolder[0] != null) {
                        throw iteHolder[0];
                    }
                }

                public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    try {
                        if (!input.exists()) {
                            // empty if block
                        }
                        ReportEditorWithPalette.this.doSave(monitor);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, op);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    protected void rebuildEditor() {
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            DesignerOutlinePage outlinePage = new DesignerOutlinePage(this.getModel());
            this.manager.addModelEventProcessor(outlinePage.getModelProcessor());
            return outlinePage;
        }
        if (type == IPropertySheetPage.class) {
            ReportPropertySheetPage sheetPage = new ReportPropertySheetPage();
            return sheetPage;
        }
        if (type == DataViewPage.class) {
            DataViewTreeViewerPage page = new DataViewTreeViewerPage(this.getModel());
            return page;
        }
        return super.getAdapter(type);
    }

    public void dispose() {
        if (this.getCommandStack() != null) {
            this.getCommandStack().flush();
        }
        this.unhookModelEventManager(this.getModel());
        super.dispose();
        this.manager = null;
    }
}

