/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import org.eclipse.birt.report.designer.internal.ui.editors.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSyntaxContext;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;

class EngineClassField
implements JSObjectMetaData.JSField,
Comparable {
    private IMemberInfo member;
    private String displayText;
    private IClassInfo classInfo;

    public EngineClassField(IMemberInfo member, IClassInfo classInfo) {
        this.classInfo = classInfo;
        this.member = member;
    }

    public String getName() {
        return this.member.getDisplayName();
    }

    public JSObjectMetaData getType() {
        JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(this.member.getDataType());
        if (meta == null) {
            try {
                return JSSyntaxContext.getJavaClassMeta(this.member.getDataType());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return meta;
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            StringBuffer strbuf = new StringBuffer(this.getName());
            strbuf.append(" ");
            strbuf.append(this.classInfo.getName());
            this.displayText = strbuf.toString();
            Object var1_1 = null;
        }
        return this.displayText;
    }

    public String getDescription() {
        return null;
    }

    public int getVisibility() {
        return 0;
    }

    public int compareTo(Object obj) {
        if (obj instanceof EngineClassField && ((EngineClassField)obj).getName() != null) {
            return this.getName().compareToIgnoreCase(((EngineClassField)obj).getName());
        }
        return 0;
    }
}

