/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import org.eclipse.birt.report.designer.internal.ui.editors.script.JSCompletionProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSScanner;
import org.eclipse.birt.report.designer.internal.ui.editors.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.internal.ui.editors.script.NonRuleBasedDamagerRepairer;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class JSSourceViewerConfiguration
extends SourceViewerConfiguration {
    private RuleBasedScanner scanner;
    private JSSyntaxContext context;

    public JSSourceViewerConfiguration() {
        this.context = new JSSyntaxContext();
    }

    public JSSourceViewerConfiguration(JSSyntaxContext context) {
        this.context = context;
    }

    public Color getColorByCategory(String categoryColor) {
        String rgbString = this.getRgbString(categoryColor);
        if (rgbString.length() <= 0) {
            rgbString = "0,0,0";
        }
        RGB rgbVal = StringConverter.asRGB((String)rgbString);
        return ColorManager.getColor((RGB)rgbVal);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__js_comment", "__js_keyword", "__js_string"};
    }

    protected RuleBasedScanner getDefaultScanner() {
        if (this.scanner == null) {
            Color defaultColor = this.getColorByCategory("defaultColor");
            this.scanner = new JSScanner();
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(defaultColor)));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer commentRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.getColorByCategory("commentColor")));
        reconciler.setDamager((IPresentationDamager)commentRepairer, "__js_comment");
        reconciler.setRepairer((IPresentationRepairer)commentRepairer, "__js_comment");
        NonRuleBasedDamagerRepairer stringRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.getColorByCategory("stringColor")));
        reconciler.setDamager((IPresentationDamager)stringRepairer, "__js_string");
        reconciler.setRepairer((IPresentationRepairer)stringRepairer, "__js_string");
        NonRuleBasedDamagerRepairer keywordRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(this.getColorByCategory("keywordColor"), null, 1));
        reconciler.setDamager((IPresentationDamager)keywordRepairer, "__js_keyword");
        reconciler.setRepairer((IPresentationRepairer)keywordRepairer, "__js_keyword");
        return reconciler;
    }

    private String getRgbString(String name) {
        String rgbStr = null;
        if ("commentColor".equals(name)) {
            rgbStr = "63,127,95";
        } else if ("stringColor".equals(name)) {
            rgbStr = "42,0,255";
        } else if ("keywordColor".equals(name)) {
            rgbStr = "127,0,85";
        } else if ("defaultColor".equals(name)) {
            rgbStr = "0,0,0";
        }
        return rgbStr;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new JSCompletionProcessor(this.context), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }
}

