/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors.pages;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.layout.ReportLayoutEditor;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

public class ReportLayoutEditorFormPage
extends ReportLayoutEditor
implements IReportEditorPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.layout";
    private int index;
    private FormEditor editor;
    private Control control;
    private int staleType;
    private ActivityStackListener commandStackListener = new ActivityStackListener(){

        public void stackChanged(ActivityStackEvent event) {
            ReportLayoutEditorFormPage.this.updateStackActions();
            ReportLayoutEditorFormPage.this.getEditor().editorDirtyStateChanged();
            ReportLayoutEditorFormPage.this.staleType = 1;
        }
    };

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null) {
            stack.addCommandStackListener(this.getCommandStackListener());
        }
    }

    public ActivityStackListener getCommandStackListener() {
        return this.commandStackListener;
    }

    public void initialize(FormEditor editor) {
        this.editor = editor;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return ID;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
    }

    public void dispose() {
        if (this.getCommandStack() != null && this.getCommandStack() instanceof WrapperCommandStack) {
            WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
            stack.removeCommandStackListener(this.getCommandStackListener());
        }
        super.dispose();
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        GraphicalViewer view;
        ModuleHandle model;
        if (this.getEditorInput() != prePage.getEditorInput()) {
            this.setInput(prePage.getEditorInput());
        }
        if ((model = this.getProvider().getReportModuleHandle((Object)this.getEditorInput())) != null && this.getModel() != model) {
            ModuleHandle oldModel = this.getModel();
            this.setModel(model);
            this.rebuildReportDesign(oldModel);
            if (this.getModel() != null) {
                this.getGraphicalViewer().setContents((Object)this.getModel());
                this.hookModelEventManager(this.getModel());
                this.markPageStale(0);
            }
            this.updateStackActions();
        }
        if ((view = this.getGraphicalViewer()) != null) {
            UIUtil.resetViewSelection((EditPartViewer)view, (boolean)true);
        }
        return true;
    }

    protected void rebuildReportDesign(Object oldModel) {
        WrapperCommandStack stack = (WrapperCommandStack)this.getCommandStack();
        if (stack != null) {
            stack.removeCommandStackListener(this.getCommandStackListener());
            stack.setActivityStack(this.getModel().getCommandStack());
            stack.addCommandStackListener(this.getCommandStackListener());
        }
        SessionHandleAdapter.getInstance().resetReportDesign(oldModel, (Object)this.getModel());
        SessionHandleAdapter.getInstance().setReportDesignHandle(this.getProvider().getReportModuleHandle((Object)this.getEditorInput()));
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.editorDirtyStateChanged();
        } else {
            super.firePropertyChange(type);
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected IReportProvider getProvider() {
        IReportProvider provider = (IReportProvider)this.editor.getAdapter(IReportProvider.class);
        if (provider == null) {
            provider = super.getProvider();
        }
        return provider;
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report layout page finalized");
        }
        super.finalize();
    }
}

