/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfOutline;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.birt.report.engine.api.TOCNode;

public class TOCHandler {
    private TOCNode root;
    private PdfOutline outline;
    private Set bookmarks;

    public TOCHandler(TOCNode root, PdfOutline outline, Set bookmarks) {
        this.root = root;
        this.outline = outline;
        this.bookmarks = bookmarks;
    }

    public TOCNode getTOCRoot() {
        return this.root;
    }

    public void createTOC() {
        this.createTOC(this.root, this.outline, this.bookmarks);
    }

    private void createTOC(TOCNode tocNode, PdfOutline pol, Set bookmarks) {
        if (null == tocNode || null == tocNode.getChildren()) {
            return;
        }
        Iterator i = tocNode.getChildren().iterator();
        while (i.hasNext()) {
            TOCNode node = (TOCNode)i.next();
            if (!bookmarks.contains(node.getBookmark())) continue;
            PdfOutline outline = new PdfOutline(pol, PdfAction.gotoLocalPage((String)node.getBookmark(), (boolean)false), node.getDisplayString());
            this.createTOC(node, outline, bookmarks);
        }
    }
}

