/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

final class ByteArrayConversion {
    ByteArrayConversion() {
    }

    static int bytesLEasUINT(byte[] bytes, int start_offset, int end_offset) {
        int result = bytes[start_offset] & 0xFF;
        for (int i = start_offset + 1; i < bytes.length && i < end_offset; ++i) {
            result = result << 8 | bytes[i] & 0xFF;
        }
        return result;
    }

    static final int bytesLEasINT(byte[] bytes, int start_offset, int end_offset) {
        boolean is_negative = false;
        if ((bytes[start_offset] & 0x80) != 0) {
            is_negative = true;
        }
        int n = start_offset;
        bytes[n] = (byte)(bytes[n] & 0x7F);
        int result = ByteArrayConversion.bytesLEasUINT(bytes, start_offset, end_offset);
        if (is_negative) {
            int max_minus = (int)Math.pow(2.0, (end_offset - start_offset) * 8 - 1);
            result -= max_minus;
        }
        return result;
    }

    static final void ulongAsBytesBE(long value, byte[] bytes, int startOff, int endOff) {
        int i = endOff - 1;
        int shift_cnt = 0;
        while (i >= startOff) {
            bytes[i] = (byte)(value >> shift_cnt & 0xFFL);
            --i;
            shift_cnt += 8;
        }
    }

    static final void uintAsBytesBE(int value, byte[] bytes, int startOff, int endOff) {
        ByteArrayConversion.ulongAsBytesBE(value, bytes, startOff, endOff);
    }

    static final void uintAsBytesLE(int value, byte[] bytes, int startOff, int endOff) {
        int i = startOff;
        int shift_cnt = 0;
        while (i < endOff) {
            bytes[i] = (byte)(value >> shift_cnt & 0xFF);
            ++i;
            shift_cnt += 8;
        }
    }

    static final void intAsBytesLE(int value, byte[] bytes, int startOffset, int endOffset) {
        if (value < 0) {
            int abs_value = -value;
            int max_minus = (int)Math.pow(2.0, (endOffset - startOffset) * 8 - 1);
            ByteArrayConversion.uintAsBytesLE(max_minus - abs_value, bytes, startOffset, endOffset);
            int n = endOffset - 1;
            bytes[n] = (byte)(bytes[n] | 0x80);
        } else {
            ByteArrayConversion.uintAsBytesLE(value, bytes, startOffset, endOffset);
        }
    }
}

