/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DriverInstancePropertySource
implements IPropertySource {
    private static final String P_NAME = "name";
    private static final String P_ID = "id";
    private static final String P_VISIBLE = "visible";
    private static final String P_CATEGORY = "category";
    private static final String P_CUSTOM_PROPERTY_DESCRIPTOR = "customPropertyDescriptor";
    private static final String METHOD_SET_CATEGORY = "setCategory";
    private DriverInstance mDI;
    private TemplateDescriptor descriptor = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public DriverInstancePropertySource(DriverInstance di) {
        this.mDI = di;
        this.descriptor = this.mDI.getTemplate();
    }

    public Object getEditableValue() {
        return this.mDI;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> descList = new ArrayList<Object>();
        if (this.descriptor != null) {
            IConfigurationElement[] props = this.descriptor.getProperties();
            ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
            for (int i = 0; i < props.length; ++i) {
                String visible = props[i].getAttribute(P_VISIBLE);
                boolean propvisible = true;
                if (visible != null && visible.equalsIgnoreCase(Boolean.toString(false))) {
                    propvisible = false;
                }
                if (!propvisible) continue;
                list.add(props[i]);
            }
            if (list.size() > 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    IConfigurationElement ice = (IConfigurationElement)iter.next();
                    String name = ice.getAttribute(P_NAME);
                    String id = ice.getAttribute(P_ID);
                    String ctceClass = ice.getAttribute(P_CUSTOM_PROPERTY_DESCRIPTOR);
                    String category = ice.getAttribute(P_CATEGORY);
                    if (category == null) {
                        category = ConnectivityUIPlugin.getDefault().getResourceString("properties.category.general");
                    }
                    if (ctceClass != null) {
                        if (ctceClass == null) continue;
                        try {
                            Class<?> tceClass = Class.forName(ctceClass);
                            Constructor<?> constructor = tceClass.getConstructor(class$java$lang$Object == null ? DriverInstancePropertySource.class$("java.lang.Object") : class$java$lang$Object, class$java$lang$String == null ? DriverInstancePropertySource.class$("java.lang.String") : class$java$lang$String);
                            Method method = tceClass.getMethod(METHOD_SET_CATEGORY, class$java$lang$String == null ? DriverInstancePropertySource.class$("java.lang.String") : class$java$lang$String);
                            Object pd = constructor.newInstance(id, name);
                            if (category != null) {
                                method.invoke(pd, category);
                            }
                            descList.add(pd);
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    TextPropertyDescriptor tpd = new TextPropertyDescriptor((Object)id, name);
                    if (category != null) {
                        tpd.setCategory(category);
                    }
                    descList.add(tpd);
                }
            }
            if (descList.size() > 0) {
                IPropertyDescriptor[] pdArray = descList.toArray(new IPropertyDescriptor[descList.size()]);
                Arrays.sort(pdArray, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        IPropertyDescriptor pd1 = (IPropertyDescriptor)o1;
                        IPropertyDescriptor pd2 = (IPropertyDescriptor)o2;
                        return pd1.getDisplayName().compareTo(pd2.getDisplayName());
                    }
                });
                return pdArray;
            }
        }
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        if (this.descriptor != null) {
            String idStr = (String)id;
            IPropertySet propSet = this.mDI.getPropertySet();
            String propval = propSet.getBaseProperties().getProperty(idStr);
            if (propval != null && propval.length() > 0) {
                return propval;
            }
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String strid = (String)id;
        if (this.mDI.getPropertySet() != null) {
            this.mDI.getPropertySet().getBaseProperties().setProperty(strid, (String)value);
        }
    }
}

