/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class CPVersionPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final int INDENT_TECH_VERSION = 20;

    public CPVersionPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        IConnectionProfile profile = this.getConnectionProfile();
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.desc", new Object[]{profile.getName()}));
        Properties props = profile.getBaseProperties();
        if (props.getProperty("org.eclipse.datatools.connectivity.server.name") == null) {
            Label label = new Label(content, 0);
            label.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.label.versionUnavailable"));
            GridData data = new GridData(768);
            label.setLayoutData((Object)data);
        } else {
            Composite serverVersionContainer = new Composite(content, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            serverVersionContainer.setLayout((Layout)layout);
            GridData data = new GridData(768);
            serverVersionContainer.setLayoutData((Object)data);
            Label label = new Label(serverVersionContainer, 0);
            label.setText(props.getProperty("org.eclipse.datatools.connectivity.server.name") + ':');
            data = new GridData(32);
            label.setLayoutData((Object)data);
            label = new Label(serverVersionContainer, 0);
            label.setText(props.getProperty("org.eclipse.datatools.connectivity.server.version"));
            data = new GridData(32);
            label.setLayoutData((Object)data);
            ArrayList<String[]> techVersions = new ArrayList<String[]>();
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith("org.eclipse.datatools.connectivity.technology.") || !key.endsWith(".mame")) continue;
                String name = (String)entry.getValue() + ':';
                String verKey = key.substring(0, key.lastIndexOf(46)) + ".version";
                String version = props.getProperty(verKey);
                if (version == null || version.length() == 0) {
                    version = ConnectionProfileConstants.UNKNOWN_VERSION;
                }
                techVersions.add(new String[]{name, version});
            }
            if (techVersions.size() > 0) {
                label = new Label(content, 0);
                label.setText(ConnectivityUIPlugin.getDefault().getResourceString("CPVersionPropertyPage.label.techVersions"));
                data = new GridData();
                data.horizontalSpan = 2;
                label.setLayoutData((Object)data);
                Composite techVersionContainer = new Composite(content, 0);
                layout = new GridLayout(2, false);
                techVersionContainer.setLayout((Layout)layout);
                data = new GridData(768);
                data.horizontalIndent = 20;
                techVersionContainer.setLayoutData((Object)data);
                Iterator it2 = techVersions.iterator();
                while (it2.hasNext()) {
                    String[] pair = (String[])it2.next();
                    label = new Label(techVersionContainer, 0);
                    label.setText(pair[0]);
                    data = new GridData(32);
                    label.setLayoutData((Object)data);
                    label = new Label(techVersionContainer, 0);
                    label.setText(pair[1]);
                    data = new GridData(32);
                    label.setLayoutData((Object)data);
                }
            }
        }
        return content;
    }

    private IConnectionProfile getConnectionProfile() {
        IAdaptable element = this.getElement();
        IConnectionProfile profile = (IConnectionProfile)element.getAdapter(IConnectionProfile.class);
        return profile;
    }
}

