/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.forms.editor.FormEditor;

public class PreviewAction
implements IWorkbenchWindowActionDelegate {
    public static final String PreviewInWebViewerActionId = "org.eclipse.birt.report.designer.ui.actions.PreviewInWebviewerAction";
    public static final String PreviewInHtmlActionId = "org.eclipse.birt.report.designer.ui.actions.PreviewInHtmlAction";
    public static final String PreviewInPDFActionId = "org.eclipse.birt.report.designer.ui.actions.PreviewInPDFAction";
    protected IWorkbenchWindow window = null;

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run(IAction action) {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Preview action >> Run ...");
        }
        if (PreviewInHtmlActionId.equalsIgnoreCase(action.getId())) {
            this.preview("html", false);
        } else if (PreviewInPDFActionId.equalsIgnoreCase(action.getId())) {
            this.doPDFPreview();
        } else {
            this.preview("html", true);
        }
    }

    protected void preview(String format, boolean allowPage) {
        FormEditor editor = UIUtil.getActiveReportEditor((boolean)false);
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (editor != null && model.needsSave()) {
            editor.doSave(null);
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("FORMAT_KEY", format);
        options.put("ALLOW_PAGE_KEY", allowPage);
        options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
        WebViewer.display((String)model.getFileName(), options);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    protected void doPDFPreview() {
        if (Platform.getBundle((String)"com.lowagie.itext") != null) {
            this.preview("pdf", false);
        } else {
            MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.getString((String)"designer.preview.previewaction.ErrorMessage.title"), (String)Messages.getString((String)"designer.preview.previewaction.ErrorMessage"));
        }
    }
}

