/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;

public class DataRequestSessionImpl
extends DataRequestSession {
    private DataEngine dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataRequestSessionImpl(DataSessionContext context) throws BirtException {
        if (context == null) {
            throw new AdapterException("context.null.error");
        }
        this.dataEngine = DataEngine.newDataEngine((DataEngineContext)context.getDataEngineContext());
        this.modelAdaptor = new ModelAdapter(context);
        this.sessionContext = context;
    }

    public void defineDataSource(IBaseDataSourceDesign design) throws BirtException {
        this.dataEngine.defineDataSource(design);
    }

    public void defineDataSet(IBaseDataSetDesign design) throws BirtException {
        this.dataEngine.defineDataSet(design);
    }

    public IResultMetaData getDataSetMetaData(String dataSetName, boolean useCache) throws BirtException {
        return this.getDataSetMetaData(this.sessionContext.getModuleHandle().findDataSet(dataSetName), useCache);
    }

    public IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).getDataSetMetaData(dataSetHandle, useCache);
    }

    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueSet(dataSet, inputParamBindings, columnBindings, boundColumnName, null);
    }

    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        Object value;
        ArrayList temp = new ArrayList();
        while (columnBindings.hasNext()) {
            temp.add(columnBindings.next());
        }
        if (this.referToAggregation(temp, boundColumnName)) {
            return new ArrayList();
        }
        IQueryResults queryResults = this.getGroupingQueryResults(dataSet, inputParamBindings, temp.iterator(), boundColumnName);
        IResultIterator resultIt = queryResults.getResultIterator();
        int maxRowCount = -1;
        ArrayList<Object> values = new ArrayList<Object>();
        if (requestInfo != null) {
            if (requestInfo.getStartRow() >= 0) {
                resultIt.moveTo(requestInfo.getStartRow());
                value = resultIt.getValue(boundColumnName);
                values.add(value);
            }
            maxRowCount = requestInfo.getMaxRow();
        }
        while (resultIt.next() && maxRowCount != 0) {
            value = resultIt.getValue(boundColumnName);
            values.add(value);
            resultIt.skipToEnd(1);
            --maxRowCount;
        }
        resultIt.close();
        queryResults.close();
        return values;
    }

    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).refreshMetaData(dataSetHandle);
    }

    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        return new DataSetMetaDataHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).refreshMetaData(dataSetHandle, holdEvent);
    }

    public IQueryResults executeQuery(QueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) throws BirtException {
        return new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext).executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt);
    }

    public IQueryResults getQueryResults(String queryResultID) throws BirtException {
        return this.dataEngine.getQueryResults(queryResultID);
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        this.dataEngine.clearCache(dataSource, dataSet);
    }

    public IPreparedQuery prepare(IQueryDefinition query, Map appContext) throws BirtException {
        if (appContext == null) {
            appContext = this.sessionContext.getAppContext();
        }
        return this.dataEngine.prepare(query, appContext);
    }

    public IPreparedQuery prepare(IQueryDefinition query) throws BirtException {
        return this.dataEngine.prepare(query, this.sessionContext.getAppContext());
    }

    public void closeDataSource(String dataSourceName) throws BirtException {
        this.dataEngine.closeDataSource(dataSourceName);
    }

    public IModelAdapter getModelAdaptor() {
        return this.modelAdaptor;
    }

    public void shutdown() {
        this.dataEngine.shutdown();
        this.dataEngine = null;
    }

    private IQueryResults getGroupingQueryResults(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        if (!$assertionsDisabled && dataSet == null) {
            throw new AssertionError();
        }
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSet.getQualifiedName());
        GroupDefinition group = new GroupDefinition();
        group.setKeyColumn(boundColumnName);
        query.addGroup(group);
        query.setUsesDetails(false);
        ModuleHandle moduleHandle = this.sessionContext.getModuleHandle();
        if (moduleHandle == null) {
            moduleHandle = dataSet.getModuleHandle();
        }
        QueryExecutionHelper execHelper = new QueryExecutionHelper(this.dataEngine, this.modelAdaptor, this.sessionContext);
        IQueryResults results = execHelper.executeQuery(query, inputParamBindings, null, columnBindings);
        return results;
    }

    private boolean referToAggregation(List bindings, String boundColumnName) throws BirtException {
        if (boundColumnName == null) {
            return true;
        }
        Iterator columnBindings = bindings.iterator();
        while (columnBindings != null && columnBindings.hasNext()) {
            ComputedColumn column = this.modelAdaptor.adaptComputedColumn((ComputedColumnHandle)columnBindings.next());
            if (!column.getName().equals(boundColumnName)) continue;
            ScriptExpression sxp = (ScriptExpression)column.getExpression();
            if (ExpressionUtil.hasAggregation((String)sxp.getText())) {
                return true;
            }
            Iterator columnBindingNameIt = ExpressionUtil.extractColumnExpressions((String)sxp.getText()).iterator();
            while (columnBindingNameIt.hasNext()) {
                IColumnBinding columnBinding = (IColumnBinding)columnBindingNameIt.next();
                if (!this.referToAggregation(bindings, columnBinding.getResultSetColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.dataEngine.getCachedDataSetMetaData(dataSource, dataSet);
    }

    static {
        $assertionsDisabled = !DataRequestSessionImpl.class.desiredAssertionStatus();
    }
}

