/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetTypesProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSourceComboProvider;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DtpManifestExplorer;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.odadatasource.wizards.AbstractDataSetWizard;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSetDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataSetBasePage
extends WizardPage
implements ISelectionChangedListener {
    private transient Text nameEditor = null;
    private transient ComboViewer dataSourceViewer = null;
    private transient ComboViewer dataSetTypeChooser = null;
    private transient boolean useTransaction = true;
    private static final String EMPTY_NAME = Messages.getString((String)"error.emptyName");
    private static final String DUPLICATE_NAME = Messages.getString((String)"error.duplicateName");
    private static final String CREATE_PROMPT = Messages.getString((String)"dataset.message.create");
    private String originalName;
    private transient DataSourceHandle newDataSource = null;
    private Hashtable htDataSetWizards = new Hashtable(10);
    private static final String SCRIPT_DATASET_NAME = "Scripted Data Set";
    private ISelection dataSourceSelection;
    private ISelection dateSetTypeSelection = null;
    private transient DataSetDesignSession m_designSession = null;
    private boolean useODAV3 = false;

    public DataSetBasePage(boolean useTransaction) {
        super("DataSet Base Page");
        this.setTitle(Messages.getString((String)"dataset.new"));
        this.setMessage(Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create"));
        this.useTransaction = useTransaction;
        this.setImage();
    }

    private void setImage() {
        URL url = null;
        try {
            url = new URL(ReportPlugin.getDefault().getBundle().getEntry("/"), "icons/wizban/dataset_wizard.gif");
        }
        catch (MalformedURLException e) {
            ExceptionHandler.handle(e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.setImageDescriptor(desc);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.datasetName"));
        this.nameEditor = new Text(composite, 2048);
        String name = ReportPlugin.getDefault().getCustomName("DataSet");
        if (name != null) {
            this.nameEditor.setText(Utility.getUniqueDataSetName(name));
        } else {
            this.nameEditor.setText(Utility.getUniqueDataSetName(Messages.getString((String)"dataset.new.defaultName")));
        }
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.setToolTipText(Messages.getString((String)"DataSetBasePage.tooltip"));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtil.isBlank((String)DataSetBasePage.this.nameEditor.getText().trim())) {
                    DataSetBasePage.this.setMessage(EMPTY_NAME, 3);
                } else if (DataSetBasePage.this.isDuplicateName()) {
                    DataSetBasePage.this.setMessage(DUPLICATE_NAME, 3);
                } else if (DataSetBasePage.this.containDotCharactor(DataSetBasePage.this.nameEditor.getText())) {
                    String msg = Messages.getFormattedString((String)"error.invalidName", (Object[])new Object[]{DataSetBasePage.this.nameEditor.getText()});
                    DataSetBasePage.this.setMessage(msg, 3);
                } else {
                    DataSetBasePage.this.setMessage(CREATE_PROMPT);
                }
                DataSetBasePage.this.setPageComplete(!DataSetBasePage.this.hasWizard() && DataSetBasePage.this.getMessageType() != 3);
            }
        });
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.dataSource"));
        this.dataSourceViewer = new ComboViewer(composite, 12);
        this.dataSourceViewer.getControl().setLayoutData((Object)new GridData(768));
        DataSourceComboProvider provider = new DataSourceComboProvider();
        this.dataSourceViewer.setContentProvider((IContentProvider)provider);
        this.dataSourceViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.dataSourceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ArrayList<DataSourceHandle> dataSources = Utility.getVisibleDataSources();
        if (dataSources == null) {
            dataSources = new ArrayList<DataSourceHandle>(10);
        }
        if (this.newDataSource != null) {
            dataSources.add(0, this.newDataSource);
        }
        Object[] objs = dataSources.toArray();
        Arrays.sort(objs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((DataSourceHandle)o1).getName().compareTo(((DataSourceHandle)o2).getName());
            }
        });
        dataSources.clear();
        for (int i = 0; i < objs.length; ++i) {
            dataSources.add((DataSourceHandle)objs[i]);
        }
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.datasetType"));
        this.dataSetTypeChooser = new ComboViewer(composite, 12);
        this.dataSetTypeChooser.getControl().setLayoutData((Object)new GridData(768));
        DataSetTypesProvider dataSetTypes = new DataSetTypesProvider();
        this.dataSetTypeChooser.setContentProvider((IContentProvider)dataSetTypes);
        this.dataSetTypeChooser.setLabelProvider((IBaseLabelProvider)dataSetTypes);
        this.dataSetTypeChooser.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DataSetBasePage.this.dataSetTypeChooser.getCombo().isEnabled()) {
                    DataSetBasePage.this.dateSetTypeSelection = DataSetBasePage.this.dataSetTypeChooser.getSelection();
                    DataSetBasePage.this.setPageComplete(!DataSetBasePage.this.hasWizard() && DataSetBasePage.this.getMessageType() != 3);
                }
            }
        });
        this.dataSourceViewer.setInput(dataSources);
        this.setControl((Control)composite);
        this.refreshFocus();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_Dataset_ID");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
        if (visible) {
            List dataSourceList = (List)this.dataSourceViewer.getInput();
            if (dataSourceList.size() > 0) {
                if (this.dataSourceSelection == null) {
                    this.dataSourceSelection = new StructuredSelection(dataSourceList.get(0));
                }
                this.dataSourceViewer.setSelection(this.dataSourceSelection);
            }
            this.refreshFocus();
        }
    }

    protected void refreshFocus() {
        this.nameEditor.setFocus();
    }

    private boolean isDuplicateName() {
        String name = this.nameEditor.getText().trim();
        return !name.equals(this.originalName) && Utility.checkDataSetName(name);
    }

    public String getDataSetName() {
        return this.nameEditor.getText();
    }

    private boolean containDotCharactor(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(".") >= 0;
    }

    protected final DataSourceHandle getSelectedDataSource() {
        return (DataSourceHandle)((IStructuredSelection)this.dataSourceViewer.getSelection()).getFirstElement();
    }

    final DataSourceHandle getNewDataSource() {
        return this.newDataSource;
    }

    final void setNewDataSource(DataSourceHandle newDataSourceHandle) {
        this.newDataSource = newDataSourceHandle;
    }

    public IWizardPage getNextPage() {
        if (this.dataSetTypeChooser.getCombo().isEnabled()) {
            if (this.useODAV3) {
                return this.getNextPageODAV3();
            }
            return this.getNextPageODAV2();
        }
        this.setPageComplete(true);
        return super.getNextPage();
    }

    private IWizardPage getNextPageODAV3() {
        DataSourceDesign dataSourceDesign = new ModelOdaAdapter().createDataSourceDesign((OdaDataSourceHandle)this.getSelectedDataSource());
        DataSetType dataSetElement = (DataSetType)((Object[])this.getSelectedDataSet())[0];
        String dataSetTypeName = dataSetElement.getID();
        try {
            if (this.m_designSession == null) {
                this.m_designSession = DataSetDesignSession.startNewDesign((String)this.nameEditor.getText().trim(), (String)dataSetTypeName, (DataSourceDesign)dataSourceDesign);
            } else {
                this.m_designSession.restartNewDesign(this.nameEditor.getText().trim(), dataSetTypeName, dataSourceDesign);
            }
            this.setPageComplete(true);
            return this.m_designSession.getWizardStartingPage();
        }
        catch (OdaException e) {
            return null;
        }
    }

    private IWizardPage getNextPageODAV2() {
        IConfigurationElement element = (IConfigurationElement)((Object[])((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement())[1];
        if (element != null) {
            IConfigurationElement[] elements;
            AbstractDataSetWizard newWizard = (AbstractDataSetWizard)((Object)this.htDataSetWizards.get(element.getAttribute("id")));
            if (newWizard == null && (elements = element.getChildren("newDataSetWizard")).length > 0) {
                try {
                    Object wizard = elements[0].createExecutableExtension("class");
                    if (wizard instanceof AbstractDataSetWizard) {
                        newWizard = (AbstractDataSetWizard)((Object)wizard);
                        newWizard.setConfigurationElement(element);
                        newWizard.addPages();
                        newWizard.setUseTransaction(this.useTransaction);
                        this.htDataSetWizards.put(element.getAttribute("id"), newWizard);
                    }
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e);
                }
            }
            if (newWizard != null) {
                newWizard.setDataSource(this.getSelectedDataSource());
                newWizard.setDataSetName(this.nameEditor.getText().trim());
                if (newWizard.getDataSet() != null) {
                    try {
                        newWizard.getDataSet().setDataSource(newWizard.getDataSource().getName());
                        newWizard.getDataSet().setName(newWizard.getDataSetName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                return newWizard.getStartingPage();
            }
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return !this.isPageComplete() && this.getMessageType() != 3 && !StringUtil.isBlank((String)this.nameEditor.getText()) && (!this.dataSetTypeChooser.getCombo().isEnabled() || this.dataSetTypeChooser.getSelection() != null && ((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement() != null);
    }

    /*
     * Unable to fully structure code
     */
    public void selectionChanged(SelectionChangedEvent event) {
        this.dataSourceSelection = this.dataSourceViewer.getSelection();
        handle = (DataSourceHandle)((IStructuredSelection)event.getSelection()).getFirstElement();
        dataSets = null;
        if (handle instanceof OdaDataSourceHandle) {
            type = ((OdaDataSourceHandle)handle).getExtensionID();
            this.useODAV3 = DesignSessionUtil.hasValidOdaDesignUIExtension((String)type);
            try {
                extMF = DtpManifestExplorer.getInstance().getExtensionManifest(type);
                if (extMF == null) ** GOTO lbl24
                dataSetTypes = extMF.getDataSetTypes();
                dataSets = new Object[dataSetTypes.length];
                for (n = 0; n < dataSetTypes.length; ++n) {
                    dataSets[n] = new Object[2];
                    ((Object[])dataSets[n])[0] = dataSetTypes[n];
                    ((Object[])dataSets[n])[1] = DataSetProvider.findDataSetElement(dataSetTypes[n].getID(), type);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle(ex);
            }
        } else if (handle instanceof ScriptDataSourceHandle) {
            this.useODAV3 = false;
            dataSets = new Object[]{"Scripted Data Set"};
        }
lbl24:
        // 6 sources

        this.dataSetTypeChooser.setInput(dataSets);
        if (handle instanceof ScriptDataSourceHandle) {
            this.dataSetTypeChooser.getCombo().setEnabled(false);
            this.setPageComplete(false);
        } else {
            this.dataSetTypeChooser.getCombo().setEnabled(true);
            this.setPageComplete(this.hasWizard() == false && this.getMessageType() != 3);
        }
        if (dataSets != null && dataSets.length > 0) {
            if (dataSets.length > 1 && this.dateSetTypeSelection != null) {
                index = this.getSelectedDateSetTypeIndex(dataSets, (StructuredSelection)this.dateSetTypeSelection);
                this.dataSetTypeChooser.setSelection((ISelection)new StructuredSelection(dataSets[index]));
            } else {
                this.dataSetTypeChooser.setSelection((ISelection)new StructuredSelection(dataSets[0]));
            }
        }
    }

    private int getSelectedDateSetTypeIndex(Object[] dataSets, StructuredSelection dateSetTypeSelection) {
        int index = 0;
        for (int i = 0; i < dataSets.length; ++i) {
            if (!((DataSetType)((Object[])dataSets[i])[0]).getID().equals(((DataSetType)((Object[])dateSetTypeSelection.getFirstElement())[0]).getID())) continue;
            index = i;
            break;
        }
        return index;
    }

    private Object getSelectedDataSet() {
        return ((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement();
    }

    private boolean hasWizard() {
        if (this.getSelectedDataSet() instanceof Object[]) {
            IConfigurationElement element = (IConfigurationElement)((Object[])this.getSelectedDataSet())[1];
            if (element != null) {
                AbstractDataSetWizard newWizard = (AbstractDataSetWizard)((Object)this.htDataSetWizards.get(element.getAttribute("id")));
                if (newWizard != null) {
                    return true;
                }
                IConfigurationElement[] v3elements = element.getChildren("dataSetWizard");
                IConfigurationElement[] v2elements = element.getChildren("newDataSetWizard");
                if (v3elements.length > 0 || v2elements.length > 0) {
                    return true;
                }
            }
        } else if (this.getSelectedDataSet() != null && this.getSelectedDataSet().toString().equals(SCRIPT_DATASET_NAME)) {
            return true;
        }
        return false;
    }

    DataSetHandle createSelectedDataSet() {
        DataSetHandle dataSetHandle = null;
        try {
            dataSetHandle = this.useODAV3 ? this.createDataSetODAV3() : this.createDataSetODAV2();
            return dataSetHandle;
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return null;
        }
        catch (IllegalStateException e) {
            ExceptionHandler.handle(e);
            return null;
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    private DataSetHandle createDataSetODAV3() throws OdaException, SemanticException, IllegalStateException {
        ModuleHandle parentHandle = Utility.getReportModuleHandle();
        OdaDataSetHandle dataSetHandle = DTPUtil.getInstance().createOdaDataSetHandle(this.m_designSession.finish().getResponse(), parentHandle);
        this.m_designSession = null;
        return dataSetHandle;
    }

    private DataSetHandle createDataSetODAV2() throws SemanticException {
        String dataSetTypeName = null;
        if (this.getSelectedDataSet() instanceof Object[]) {
            DataSetType dataSetElement = (DataSetType)((Object[])this.getSelectedDataSet())[0];
            dataSetTypeName = dataSetElement.getID();
        } else {
            dataSetTypeName = "ScriptSelectDataSet";
        }
        return this.createDataSet(dataSetTypeName);
    }

    private DataSetHandle createDataSet(String dataSetType) throws SemanticException {
        DataSourceHandle source = this.getSelectedDataSource();
        if (source instanceof OdaDataSourceHandle) {
            OdaDataSetHandle dsHandle = Utility.newOdaDataSet(this.getDataSetName().trim(), dataSetType);
            dsHandle.setDataSource(source.getQualifiedName());
            dsHandle.setQueryText("");
            return dsHandle;
        }
        if (source instanceof ScriptDataSourceHandle) {
            ScriptDataSetHandle dsHandle = Utility.newScriptDataSet(this.getDataSetName());
            dsHandle.setDataSource(source.getName());
            return dsHandle;
        }
        return null;
    }
}

