/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.PopupSelectionList;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ChoiceSetFactory;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class DataSetFiltersPage
extends AbstractDescriptionPropertyPage
implements ITableLabelProvider {
    private transient PropertyHandleTableViewer viewer = null;
    private transient DataSetViewData[] columns = null;
    private transient String[] columnExpressions = null;
    private transient PropertyHandle filters = null;
    private FilterCondition originalStructure = null;
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.expression"), Messages.getString((String)"dataset.editor.title.operator"), Messages.getString((String)"dataset.editor.title.value1"), Messages.getString((String)"dataset.editor.title.value2")};
    private static String[] cellProperties = new String[]{"expr", "operator", "value1", "value2"};
    private static String[] operators;
    private static String[] operatorDisplayNames;

    public Control createContents(Composite parent) {
        this.initColumnNames();
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "expr")]);
        column.setWidth(150);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "operator")]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "value1")]);
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "value2")]);
        column.setWidth(100);
        this.initializeFilters();
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList filterList = new ArrayList(10);
                Iterator iter = DataSetFiltersPage.this.filters.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        filterList.add(iter.next());
                    }
                }
                return filterList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.viewer.getViewer().setInput((Object)this.filters);
        this.addListeners();
        this.setToolTips();
        return this.viewer.getControl();
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetFiltersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetFiltersPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetFiltersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void doNew() {
        this.doEdit(new FilterCondition());
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        FilterConditionHandle handle = (FilterConditionHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalStructure = (FilterCondition)handle.getStructure().copy();
        Utility.setStructureProperty(handle.getStructure(), "operator", this.getOperatorDisplayName(Utility.getStructureProperty(handle.getStructure(), "operator")));
        this.doEdit(handle);
    }

    private void doEdit(Object structureOrHandle) {
        FilterInputDialog dlg = new FilterInputDialog(structureOrHandle);
        if (dlg.open() == 0) {
            this.update(structureOrHandle);
        }
    }

    private void update(Object structureOrHandle) {
        FilterCondition structure = this.getStructure(structureOrHandle);
        String expression = Utility.getStructureProperty((IStructure)structure, "expr");
        if (this.isColumnName(expression)) {
            expression = this.getQualifiedExpression(expression);
            Utility.setStructureProperty((IStructure)structure, "expr", expression);
        }
        try {
            Utility.setProperty(structureOrHandle, "operator", this.getOperatorName(Utility.getStructureProperty((IStructure)structure, "operator")));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        if (structureOrHandle instanceof FilterCondition) {
            try {
                this.filters.addItem((IStructure)((FilterCondition)structureOrHandle));
                this.viewer.getViewer().refresh();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            this.viewer.getViewer().update(structureOrHandle, null);
        }
    }

    private FilterCondition getStructure(Object structureOrHandle) {
        FilterCondition structure = null;
        structure = structureOrHandle instanceof FilterCondition ? (FilterCondition)structureOrHandle : (FilterCondition)((FilterConditionHandle)structureOrHandle).getStructure();
        return structure;
    }

    private String getOperatorName(String displayName) {
        for (int i = 0; i < operatorDisplayNames.length; ++i) {
            if (!operatorDisplayNames[i].equals(displayName)) continue;
            return operators[i];
        }
        return operators[0];
    }

    private String getOperatorDisplayName(String name) {
        for (int i = 0; i < operators.length; ++i) {
            if (!operators[i].equals(name)) continue;
            return operatorDisplayNames[i];
        }
        return operatorDisplayNames[0];
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Edit"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Down"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Up"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetFiltersPage.toolTipText.Remove"));
    }

    private void initColumnNames() {
        this.columns = ((DataSetEditor)this.getContainer()).getCurrentItemModel(true, true);
        if (this.columns != null) {
            this.columnExpressions = new String[this.columns.length];
            for (int n = 0; n < this.columns.length; ++n) {
                this.columnExpressions[n] = this.columns[n].getName();
            }
        }
    }

    private boolean isColumnName(String name) {
        for (int n = 0; n < this.columnExpressions.length; ++n) {
            if (!this.columnExpressions[n].equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getQualifiedExpression(String expression) {
        return ExpressionUtil.createJSRowExpression((String)expression);
    }

    private void initializeFilters() {
        this.filters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("filter");
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.filters"), 0);
        this.initColumnNames();
        this.setPageProperties();
        this.viewer.getViewer().getTable().select(0);
    }

    private void setPageProperties() {
        boolean filterConditionExists = false;
        filterConditionExists = this.filters != null && this.filters.getListValue() != null && this.filters.getListValue().size() > 0;
        this.viewer.getEditButton().setEnabled(filterConditionExists);
        this.viewer.getDownButton().setEnabled(filterConditionExists && this.filters.getListValue().size() > 1);
        this.viewer.getUpButton().setEnabled(filterConditionExists && this.filters.getListValue().size() > 1);
        this.viewer.getRemoveButton().setEnabled(filterConditionExists);
        this.viewer.getRemoveMenuItem().setEnabled(filterConditionExists);
        this.viewer.getRemoveAllMenuItem().setEnabled(filterConditionExists);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        FilterCondition filterCondition = this.getStructure(element);
        try {
            switch (columnIndex) {
                case 0: {
                    value = Utility.getStructureProperty((IStructure)filterCondition, "expr");
                    break;
                }
                case 1: {
                    value = this.getOperatorDisplayName(Utility.getStructureProperty((IStructure)filterCondition, "operator"));
                    break;
                }
                case 2: {
                    value = Utility.getStructureProperty((IStructure)filterCondition, "value1");
                    break;
                }
                case 3: {
                    value = Utility.getStructureProperty((IStructure)filterCondition, "value2");
                }
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle(ex);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetFiltersPage.description");
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetFiltersPage.Filter.Tooltip");
    }

    static /* synthetic */ String[] access$902(DataSetFiltersPage x0, String[] x1) {
        x0.columnExpressions = x1;
        return x1;
    }

    static /* synthetic */ boolean access$1300(DataSetFiltersPage x0, String x1) {
        return x0.isColumnName(x1);
    }

    static /* synthetic */ String access$1400(DataSetFiltersPage x0, String x1) {
        return x0.getQualifiedExpression(x1);
    }

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("FilterCondition", "operator");
        IChoice[] chs = chset.getChoices();
        operators = new String[chs.length];
        operatorDisplayNames = new String[chs.length];
        for (int i = 0; i < chs.length; ++i) {
            DataSetFiltersPage.operators[i] = chs[i].getName();
            DataSetFiltersPage.operatorDisplayNames[i] = chs[i].getDisplayName();
        }
    }

    private class FilterInputDialog
    extends PropertyHandleInputDialog {
        private FilterCondition structure;
        private Map controlMap;

        private FilterInputDialog(Object structureOrHandle) {
            super(structureOrHandle);
            this.structure = null;
            this.controlMap = new Hashtable();
            this.structure = DataSetFiltersPage.this.getStructure(structureOrHandle);
        }

        protected void createCustomControls(Composite parent) {
            this.createComboBoxExpressionCell(parent, Utility.findIndex(cellProperties, "expr"));
            this.createComboBoxCell(parent, Utility.findIndex(cellProperties, "operator"));
            this.createExpressionValueCell(parent, Utility.findIndex(cellProperties, "value1"));
            this.createExpressionValueCell(parent, Utility.findIndex(cellProperties, "value2"));
        }

        private void createComboBoxExpressionCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            String value = Utility.getStructureProperty((IStructure)this.structure, cellProperties[index]);
            Combo cb = ControlProvider.createCombo(parent, 0);
            cb.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            if (DataSetFiltersPage.this.columnExpressions == null) {
                DataSetFiltersPage.access$902(DataSetFiltersPage.this, new String[0]);
            }
            cb.setItems(DataSetFiltersPage.this.columnExpressions);
            cb.setText(value);
            cb.addModifyListener(new ModifyListener(this, index, cb){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ FilterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this.val$cb = val$cb;
                }

                public void modifyText(ModifyEvent e) {
                    Utility.setStructureProperty((IStructure)FilterInputDialog.access$1000(this.this$1), DataSetFiltersPage.access$700()[this.val$index], this.val$cb.getText());
                    this.this$1.validateSyntax();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(this, cb){
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ FilterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.val$cb.getText());
                    expressionBuilder.setExpressionProvier(new DataSetExpressionProvider((DesignElementHandle)FilterInputDialog.access$1100(this.this$1).getContainer().getModel()));
                    if (expressionBuilder.open() == 0) {
                        this.val$cb.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            ControlProvider.createButton(parent, 8, (SelectionListener)listener);
        }

        private void createComboBoxCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            Combo cb = new Combo(parent, 8);
            cb.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            cb.setItems(operatorDisplayNames);
            cb.select(Utility.findIndex(cb.getItems(), Utility.getStructureProperty((IStructure)this.structure, cellProperties[index])));
            cb.addSelectionListener((SelectionListener)new SelectionAdapter(this, index, cb){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ FilterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent e) {
                    Utility.setStructureProperty((IStructure)FilterInputDialog.access$1000(this.this$1), DataSetFiltersPage.access$700()[this.val$index], this.val$cb.getText());
                    this.this$1.validateSyntax();
                }
            });
            if (this.getStructureOrHandle() instanceof FilterCondition) {
                Utility.setStructureProperty((IStructure)this.structure, cellProperties[index], cb.getText());
            }
        }

        private void createExpressionValueCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            Text tx = ControlProvider.createText(composite, Utility.getStructureProperty((IStructure)this.structure, cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(this, index, tx){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ FilterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this.val$tx = val$tx;
                }

                public void modifyText(ModifyEvent e) {
                    Utility.setStructureProperty((IStructure)FilterInputDialog.access$1000(this.this$1), DataSetFiltersPage.access$700()[this.val$index], this.val$tx.getText());
                    this.this$1.validateSyntax();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(this, tx, actions){
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ String[] val$actions;
                private final /* synthetic */ FilterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$tx = val$tx;
                    this.val$actions = val$actions;
                }

                public void widgetSelected(SelectionEvent e) {
                    Rectangle textBounds = this.val$tx.getBounds();
                    Point pt = this.val$tx.toDisplay(textBounds.x, textBounds.y);
                    Rectangle rect = new Rectangle(pt.x, pt.y, this.val$tx.getParent().getBounds().width, textBounds.height);
                    PopupSelectionList popup = new PopupSelectionList(this.val$tx.getParent().getShell());
                    popup.setItems(this.val$actions);
                    String value = popup.open(rect);
                    if (value != null) {
                        if (value.equals(this.val$actions[0])) {
                            String expression;
                            String string = expression = FilterInputDialog.access$1000(this.this$1) instanceof FilterCondition ? Utility.getStructureProperty((IStructure)FilterInputDialog.access$1000(this.this$1), "expr") : "";
                            if (DataSetFiltersPage.access$1300(FilterInputDialog.access$1100(this.this$1), expression)) {
                                expression = DataSetFiltersPage.access$1400(FilterInputDialog.access$1100(this.this$1), expression);
                            }
                            if (ExpressionUtility.isColumnExpression(expression)) {
                                try {
                                    List selectValueList = FilterInputDialog.access$1500(this.this$1, expression, (ReportElementHandle)FilterInputDialog.access$1100(this.this$1).getContainer().getModel());
                                    SelectValueDialog dlg = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                                    dlg.setSelectedValueList(selectValueList);
                                    if (dlg.open() == 0) {
                                        this.val$tx.setText(dlg.getSelectedExprValue());
                                    }
                                }
                                catch (Exception ex) {
                                    FilterInputDialog.access$1600(this.this$1, (IStatus)new Status(4, "org.eclipse.ui", 0, ex.getMessage(), null));
                                }
                            } else {
                                FilterInputDialog.access$1700(this.this$1, (IStatus)new Status(2, "org.eclipse.ui", 0, Messages.getString((String)"DataSetFiltersPage.messages.selectVauleUnavailable"), null));
                            }
                        } else if (value.equals(this.val$actions[1])) {
                            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.val$tx.getText());
                            dialog.setExpressionProvier(new DataSetExpressionProvider((DesignElementHandle)FilterInputDialog.access$1100(this.this$1).getContainer().getModel()));
                            if (dialog.open() == 0) {
                                this.val$tx.setText(dialog.getResult());
                            }
                        }
                    }
                }
            };
            Button bt = ControlProvider.createButton(composite, 1028, (SelectionListener)listener);
            composite.setLayout(new Layout(this, bt, tx){
                private final /* synthetic */ Button val$bt;
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ FilterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$bt = val$bt;
                    this.val$tx = val$tx;
                }

                public void layout(Composite editor, boolean force) {
                    Rectangle bounds = editor.getClientArea();
                    Point size = this.val$bt.computeSize(-1, -1, force);
                    this.val$tx.setBounds(0, 0, bounds.width - size.x, bounds.height);
                    this.val$bt.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
                }

                public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
                    if (wHint != -1 && hHint != -1) {
                        return new Point(wHint, hHint);
                    }
                    Point contentsSize = this.val$tx.computeSize(-1, -1, force);
                    Point buttonSize = this.val$bt.computeSize(-1, -1, force);
                    Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                    return result;
                }
            });
            this.controlMap.put(cellProperties[index], composite);
        }

        private List getSelectValueList(String selectValueExpression, ReportElementHandle currentItem) throws BirtException {
            ParamBindingHandle[] bindingParams = null;
            ArrayList<Object> selectValueList = new ArrayList<Object>();
            if (selectValueExpression != null && selectValueExpression.trim().length() > 0 && currentItem instanceof DataSetHandle) {
                IPreparedQuery queryDefn = DataSetProvider.getCurrentInstance().prepareQuery((DataSetHandle)currentItem, bindingParams, true, false);
                BaseQueryDefinition query = (BaseQueryDefinition)queryDefn.getReportQueryDefn();
                String bindingNameGroup = "GROUP_SELECTVALUE";
                ScriptExpression bindingExprGroup = new ScriptExpression(ExpressionUtility.getReplacedColRefExpr(selectValueExpression));
                GroupDefinition groupDefn = new GroupDefinition();
                groupDefn.setKeyExpression("row.GROUP_SELECTVALUE");
                if (bindingNameGroup != null) {
                    query.addResultSetExpression(bindingNameGroup, (IBaseExpression)bindingExprGroup);
                }
                query.addGroup(groupDefn);
                query.setUsesDetails(false);
                IPreparedQuery preparedQuery = DataSetProvider.getCurrentInstance().prepareQuery((DataSetHandle)currentItem, (IQueryDefinition)query, true, false);
                IQueryResults results = preparedQuery.execute(null);
                if (results != null) {
                    IResultIterator iter = null;
                    iter = results.getResultIterator();
                    if (iter != null) {
                        while (iter.next()) {
                            Object candiateValue = iter.getValue(bindingNameGroup);
                            if (candiateValue != null) {
                                selectValueList.add(candiateValue);
                            }
                            iter.skipToEnd(1);
                        }
                    }
                    results.close();
                }
            } else {
                selectValueList.clear();
            }
            return selectValueList;
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            return null;
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            Composite[] composites = new Composite[]{(Composite)this.controlMap.get("value1"), (Composite)this.controlMap.get("value2")};
            for (int i = 0; i < composites.length; ++i) {
                if (composites[i] != null) continue;
                return null;
            }
            String operator = DataSetFiltersPage.this.getOperatorName(Utility.getStructureProperty((IStructure)this.structure, "operator"));
            if (!operator.equals("")) {
                if (operator.equals("is-null") || operator.equals("is-not-null") || operator.equals("is-true") || operator.equals("is-false")) {
                    for (int i = 0; i < composites.length; ++i) {
                        Control[] controls = composites[i].getChildren();
                        for (int j = 0; j < controls.length; ++j) {
                            controls[j].setEnabled(false);
                            if (!(controls[j] instanceof Text) || ((Text)controls[j]).getText().equals("")) continue;
                            ((Text)controls[j]).setText("");
                        }
                    }
                } else if (operator.equals("between") || operator.equals("not-between")) {
                    for (int i = 0; i < composites.length; ++i) {
                        Control[] controls = composites[i].getChildren();
                        for (int j = 0; j < controls.length; ++j) {
                            controls[j].setEnabled(true);
                        }
                    }
                    if (Utility.getStructureProperty((IStructure)this.structure, "value1").trim().length() == 0) {
                        return this.getBlankPropertyStatus(cellLabels[Utility.findIndex(cellProperties, "value1")]);
                    }
                    if (Utility.getStructureProperty((IStructure)this.structure, "value2").trim().length() == 0) {
                        return this.getBlankPropertyStatus(cellLabels[Utility.findIndex(cellProperties, "value2")]);
                    }
                } else {
                    for (int i = 0; i < composites.length; ++i) {
                        int j;
                        Control[] controls = composites[i].getChildren();
                        if (i == 0) {
                            for (j = 0; j < controls.length; ++j) {
                                controls[j].setEnabled(true);
                            }
                            continue;
                        }
                        for (j = 0; j < controls.length; ++j) {
                            controls[j].setEnabled(false);
                            if (!(controls[j] instanceof Text) || ((Text)controls[j]).getText().equals("")) continue;
                            ((Text)controls[j]).setText("");
                        }
                    }
                    if (Utility.getStructureProperty((IStructure)this.structure, "value1").trim().length() == 0) {
                        return this.getBlankPropertyStatus(cellLabels[Utility.findIndex(cellProperties, "value1")]);
                    }
                }
            }
            if (Utility.getStructureProperty((IStructure)this.structure, "expr").trim().length() == 0) {
                return this.getBlankPropertyStatus(cellLabels[Utility.findIndex(cellProperties, "expr")]);
            }
            if (Utility.getStructureProperty((IStructure)this.structure, "operator").trim().length() == 0) {
                return this.getBlankPropertyStatus(cellLabels[Utility.findIndex(cellProperties, "operator")]);
            }
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }

        protected void rollback() {
            if (DataSetFiltersPage.this.originalStructure != null) {
                for (int i = 0; i < cellProperties.length; ++i) {
                    Utility.setStructureProperty((IStructure)this.structure, cellProperties[i], Utility.getStructureProperty((IStructure)DataSetFiltersPage.this.originalStructure, cellProperties[i]));
                }
                DataSetFiltersPage.this.originalStructure = null;
            }
        }

        protected String getTitle() {
            return super.getTitle() + " " + Messages.getString((String)"DataSetFiltersPage.title.FilterInputDialog");
        }

        static /* synthetic */ FilterCondition access$1000(FilterInputDialog x0) {
            return x0.structure;
        }

        static /* synthetic */ DataSetFiltersPage access$1100(FilterInputDialog x0) {
            return x0.DataSetFiltersPage.this;
        }

        static /* synthetic */ List access$1500(FilterInputDialog x0, String x1, ReportElementHandle x2) throws BirtException {
            return x0.getSelectValueList(x1, x2);
        }

        static /* synthetic */ void access$1600(FilterInputDialog x0, IStatus x1) {
            x0.updateStatus(x1);
        }

        static /* synthetic */ void access$1700(FilterInputDialog x0, IStatus x1) {
            x0.updateStatus(x1);
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetFiltersPage.this.setPageProperties();
        }
    }
}

