/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.JointDataSetPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class JointDataSetWizard
extends Wizard {
    private static final String CREATE_DATA_SET_TRANS_NAME = Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create");
    private transient boolean useTransaction = true;
    private JointDataSetPage dataSetPage;

    public JointDataSetWizard() {
        this(null, true);
    }

    public JointDataSetWizard(DataSourceHandle dataSourceHandle, boolean useTransaction) {
        this.useTransaction = useTransaction;
        this.dataSetPage = new JointDataSetPage(Messages.getString((String)"JointDataSetPage.pageName"));
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.dataSetPage);
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        if (this.useTransaction) {
            Utility.getCommandStack().startTrans(CREATE_DATA_SET_TRANS_NAME);
        }
        DataSetHandle joinDataSetHandle = this.dataSetPage.createSelectedDataSet();
        try {
            if (joinDataSetHandle != null) {
                DataSetUIUtil.updateColumnCache(joinDataSetHandle);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        if (this.useTransaction) {
            Utility.getCommandStack().commit();
        }
        return true;
    }
}

