/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetEditorPage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class PropertyPageWrapper
extends AbstractPropertyPage {
    private PropertyPage propertyPage = null;

    public PropertyPageWrapper(PropertyPage propertyPage) {
        this.propertyPage = propertyPage;
    }

    public Control createPageControl(Composite parent) {
        this.propertyPage.setContainer((IPreferencePageContainer)this.getContainer());
        this.propertyPage.createControl(parent);
        return this.propertyPage.getControl();
    }

    public void pageActivated() {
        if (this.propertyPage instanceof DataSetEditorPage) {
            ((DataSetEditorPage)this.propertyPage).refresh();
        }
        this.getContainer().setMessage(this.propertyPage.getMessage(), this.propertyPage.getMessageType());
    }

    public PropertyPage getPropertyPage() {
        return this.propertyPage;
    }

    public String getToolTip() {
        return this.propertyPage.getTitle();
    }

    public boolean canLeave() {
        if (this.propertyPage instanceof DataSetEditorPage) {
            if (((DataSetEditorPage)this.propertyPage).okToLeave()) {
                try {
                    DTPUtil.getInstance().updateDataSetHandle(((DataSetEditorPage)this.propertyPage).collectPageResponse(), (OdaDataSetHandle)((DataSetEditor)this.getContainer()).getModel(), false);
                }
                catch (OdaException e) {
                    ExceptionHandler.handle(e);
                }
            }
            return ((DataSetEditorPage)this.propertyPage).okToLeave();
        }
        return super.canLeave();
    }
}

