/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConnectionProfileSelectionPage
extends WizardPage {
    private transient Label dataSourceNameLabel = null;
    private transient Text connectionProfilePath = null;
    private transient Text dataSourceName = null;
    private transient String profileID = "";
    private transient String odaDataSourceID = "";
    private transient Button useDefaultDSNameCheckBox = null;
    private transient Tree odaDataSourceTree = null;
    private transient Properties dataSourceIDProperties = null;
    private transient Properties cpProperties = null;
    private transient DataSourceDesignSession m_designSession = null;
    private final String DUPLICATE_NAME = Messages.getString((String)"error.duplicateName");
    private final String EMPTY_NAME = Messages.getString((String)"error.emptyName");
    private final String DATASOURCE_NAME = Messages.getString((String)"connectionprofile.wizard.tree.datasourcename");

    public ConnectionProfileSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString((String)"connectionprofile.wizard.title.connectionprofileselect"));
        this.setMessage(Messages.getString((String)"connectionprofile.wizard.defaultmessage.connectionprofileselect"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.setupConnectionProfilePath(composite);
        this.setupTreeViewer(composite);
        this.setupDataSourceName(composite);
        this.setPageComplete(this.hasConnectionProfilePath());
        this.setControl((Control)composite);
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_ConnectionProfile_ID");
    }

    private void setupConnectionProfilePath(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"connectionprofile.wizard.label.connectionprofilestore"));
        label.setLayoutData((Object)new GridData(32));
        this.connectionProfilePath = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 260;
        this.connectionProfilePath.setLayoutData((Object)layoutData);
        this.connectionProfilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusyIndicator.showWhile((Display)(ConnectionProfileSelectionPage.this.getShell() == null ? null : ConnectionProfileSelectionPage.this.getShell().getDisplay()), (Runnable)new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ConnectionProfileSelectionPage.access$100(1.access$000(this.this$1));
                    }
                });
            }

            static /* synthetic */ ConnectionProfileSelectionPage access$000(1 x0) {
                return x0.ConnectionProfileSelectionPage.this;
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.getString((String)"connectionprofile.wizard.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionProfileSelectionPage.this.connectionProfilePath.setText(new FileDialog(ConnectionProfileSelectionPage.this.getShell()).open());
            }
        });
        button.setLayoutData((Object)new GridData(768));
    }

    private void setupTreeViewer(Composite composite) {
        this.odaDataSourceTree = new Tree(composite, 2564);
        this.odaDataSourceTree.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        this.odaDataSourceTree.setLayoutData((Object)layoutData);
        this.odaDataSourceTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleTreeSelection();
            }

            private void handleTreeSelection() {
                TreeItem item = ConnectionProfileSelectionPage.this.odaDataSourceTree.getSelection()[0];
                if (item.getParentItem() == null || ConnectionProfileSelectionPage.this.dataSourceIDProperties.containsKey(item.getData())) {
                    ConnectionProfileSelectionPage.this.dataSourceName.setText("");
                } else {
                    ConnectionProfileSelectionPage.this.profileID = item.getData().toString();
                    ConnectionProfileSelectionPage.this.odaDataSourceID = item.getParentItem().getData().toString();
                    ConnectionProfileSelectionPage.this.dataSourceName.setText(item.getText());
                }
            }
        });
        this.populateTree();
    }

    private void populateTree() {
        if (this.connectionProfilePath.getText().trim().length() == 0) {
            return;
        }
        this.resetTreeViewer();
        this.generateDataSourceIdentifiers();
        TreeItem root = new TreeItem(this.odaDataSourceTree, 0);
        root.setText(this.DATASOURCE_NAME);
        try {
            Iterator<Object> iterator = this.dataSourceIDProperties.keySet().iterator();
            while (iterator.hasNext()) {
                Object odaDataSourceId = iterator.next();
                if (!this.hasCPInstance(odaDataSourceId)) continue;
                TreeItem dsCategory = new TreeItem(root, 0);
                String dsID = odaDataSourceId.toString();
                String dsDisplayName = this.dataSourceIDProperties.getProperty(dsID);
                dsCategory.setData((Object)dsID);
                dsCategory.setText(dsDisplayName);
                this.createDSTreeItems(dsCategory);
                this.odaDataSourceTree.showItem(dsCategory);
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private void resetTreeViewer() {
        this.dataSourceName.setText("");
        this.odaDataSourceTree.removeAll();
    }

    private void generateDataSourceIdentifiers() {
        if (this.dataSourceIDProperties == null) {
            this.dataSourceIDProperties = ManifestExplorer.getInstance().getDataSourceIdentifiers();
        }
    }

    private boolean hasCPInstance(Object odaDataSourceId) throws OdaException {
        Map profiles = this.getProfileIdentifiers(odaDataSourceId.toString());
        if (profiles == null) {
            return false;
        }
        return profiles.keySet().iterator().hasNext();
    }

    private Map getProfileIdentifiers(String odaDataSourceId) {
        try {
            return DesignSessionUtil.getProfileIdentifiers((String)odaDataSourceId, (File)new Path(this.connectionProfilePath.getText()).toFile());
        }
        catch (OdaException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void createDSTreeItems(TreeItem dsCategory) throws OdaException {
        Map profiles = this.getProfileIdentifiers(dsCategory.getData().toString());
        ArrayList treeList = new ArrayList();
        Iterator iterator = profiles.keySet().iterator();
        while (iterator.hasNext()) {
            treeList.add(iterator.next());
        }
        this.createTreeItems(profiles, dsCategory, treeList, 0);
    }

    private TreeItem[] createTreeItems(Map profiles, TreeItem dsCategory, ArrayList dataSource, int style) {
        if (dataSource == null) {
            return null;
        }
        TreeItem[] item = new TreeItem[dataSource.size()];
        for (int i = 0; i < dataSource.size(); ++i) {
            item[i] = new TreeItem(dsCategory, style);
            Object source = dataSource.get(i);
            item[i].setData(source);
            item[i].setText(profiles.get(source).toString());
        }
        return item;
    }

    private void setupDataSourceName(Composite composite) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.useDefaultDSNameCheckBox = new Button(composite, 32);
        this.useDefaultDSNameCheckBox.setText(Messages.getString((String)"connectionprofile.wizard.checkbox.datasourcenameusedefaultdsname"));
        this.useDefaultDSNameCheckBox.setSelection(true);
        this.useDefaultDSNameCheckBox.setLayoutData((Object)layoutData);
        this.useDefaultDSNameCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionProfileSelectionPage.this.enableDataSourceNameEditor(!ConnectionProfileSelectionPage.this.useDefaultDSNameCheckBox.getSelection());
            }
        });
        this.dataSourceNameLabel = new Label(composite, 0);
        this.dataSourceNameLabel.setText(Messages.getString((String)"connectionprofile.wizard.label.datasourcename"));
        this.dataSourceNameLabel.setLayoutData((Object)new GridData(32));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.dataSourceName = new Text(composite, 2048);
        this.dataSourceName.setLayoutData((Object)layoutData);
        this.dataSourceName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConnectionProfileSelectionPage.this.isNameBlank()) {
                    ConnectionProfileSelectionPage.this.setMessage(ConnectionProfileSelectionPage.this.EMPTY_NAME, 3);
                    ConnectionProfileSelectionPage.this.setPageComplete(false);
                } else if (ConnectionProfileSelectionPage.this.isNameDuplicated()) {
                    ConnectionProfileSelectionPage.this.setMessage(ConnectionProfileSelectionPage.this.DUPLICATE_NAME, 3);
                    ConnectionProfileSelectionPage.this.setPageComplete(false);
                } else {
                    ConnectionProfileSelectionPage.this.setMessage(Messages.getString((String)"connectionprofile.wizard.defaultmessage.connectionprofileselect"));
                    ConnectionProfileSelectionPage.this.setPageComplete(true);
                    ConnectionProfileSelectionPage.this.setCPProperties();
                }
                ConnectionProfileSelectionPage.this.canFlipToNextPage();
                ConnectionProfileSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.enableDataSourceNameEditor(false);
    }

    private boolean isNameBlank() {
        return this.dataSourceName.getText().trim().equals("");
    }

    private boolean isNameDuplicated() {
        String name = this.dataSourceName.getText().trim();
        return Utility.checkDataSourceName(name);
    }

    private void enableDataSourceNameEditor(boolean bool) {
        this.dataSourceNameLabel.setEnabled(bool);
        this.dataSourceName.setEnabled(bool);
    }

    public boolean canFlipToNextPage() {
        return this.getMessageType() != 3 && this.hasConnectionProfilePath();
    }

    public IWizardPage getNextPage() {
        try {
            this.startNewDesignSession();
            return this.m_designSession.getWizardStartingPage();
        }
        catch (OdaException e) {
            e.printStackTrace();
            return super.getNextPage();
        }
    }

    private void startNewDesignSession() throws OdaException {
        boolean linkToProfile = false;
        DataSourceDesignSession.ProfileReference profileRef = new DataSourceDesignSession.ProfileReference(this.profileID, new Path(this.connectionProfilePath.getText()).toFile(), linkToProfile);
        if (this.m_designSession == null) {
            this.m_designSession = DataSourceDesignSession.startNewDesign((String)this.odaDataSourceID, (String)this.dataSourceName.getText(), (DataSourceDesignSession.ProfileReference)profileRef, null);
        } else {
            this.m_designSession.restartNewDesign(this.odaDataSourceID, this.dataSourceName.getText(), profileRef, null);
        }
    }

    private void setCPProperties() {
        this.cpProperties = new Properties();
        String[] cpPropertyKey = new String[]{"odaDataSourceID", "newDataSourceName", "profileInstanceId", "storageFilePath"};
        String[] cpPropertyValue = new String[]{this.odaDataSourceID, this.dataSourceName.getText(), this.profileID, this.connectionProfilePath.getText()};
        for (int i = 0; i < cpPropertyKey.length; ++i) {
            this.cpProperties.put(cpPropertyKey[i], cpPropertyValue[i]);
        }
    }

    private boolean hasConnectionProfilePath() {
        return this.connectionProfilePath.getText().trim().length() > 0;
    }

    public Properties getCPProperties() {
        return this.cpProperties;
    }

    public DataSourceDesignSession getDataSourceDesignSession() {
        return this.m_designSession;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    static /* synthetic */ void access$100(ConnectionProfileSelectionPage x0) {
        x0.populateTree();
    }
}

