/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.util.Properties;
import org.eclipse.birt.report.designer.data.ui.datasource.ConnectionProfileSelectionPage;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ConnectionProfileWizard
extends Wizard {
    private ConnectionProfileSelectionPage page = null;
    private DataSourceDesignSession m_designSession = null;
    private DataSourceDesign dataSourceDesign = null;
    private DesignElementHandle parentHandle = null;
    private DataSourceHandle dataSourceHandle = null;
    private static ConnectionProfileWizard instance = null;
    private static final String CREATE_DATA_SOURCE_TRANS_NAME = Messages.getString((String)"wizard.transaction.createDataSource");
    public static final String DATA_SOURCE_NAME = "newDataSourceName";
    public static final String PROFILE_INSTANCE_ID = "profileInstanceId";
    public static final String STOREAGE_FILE_PATH = "storageFilePath";
    public static final String DATA_SOURCE_ID = "odaDataSourceID";

    public static synchronized ConnectionProfileWizard getInstance() {
        if (instance == null) {
            instance = new ConnectionProfileWizard();
        }
        return instance;
    }

    public ConnectionProfileWizard() {
        this.addPages();
        this.setWindowTitle(Messages.getString((String)"connectionprofile.wizard.title"));
    }

    public void addPages() {
        this.page = new ConnectionProfileSelectionPage(Messages.getString((String)"connectionprofile.wizard.title.connectionprofileselect"));
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.init();
        if (this.isCustomPageUsed()) {
            this.createFromCustomPage();
        } else {
            this.createFromConnectionProfile();
        }
        this.tearDown();
        return true;
    }

    public boolean performCancel() {
        if (this.m_designSession != null) {
            this.m_designSession.cancel();
            this.m_designSession = null;
        }
        this.resetCPWizard();
        return super.performCancel();
    }

    private void init() {
        this.getActivityStack().startTrans(CREATE_DATA_SOURCE_TRANS_NAME);
        this.parentHandle = Utility.getReportModuleHandle();
    }

    private boolean isCustomPageUsed() {
        this.m_designSession = this.page.getDataSourceDesignSession();
        return this.m_designSession != null;
    }

    private void createFromCustomPage() {
        try {
            this.dataSourceHandle = DTPUtil.getInstance().createOdaDataSourceHandle(this.m_designSession.finish().getResponse(), (ModuleHandle)this.parentHandle);
            this.m_designSession = null;
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void createFromConnectionProfile() {
        Properties cpProperties = this.page.getCPProperties();
        String odaDataSourceID = cpProperties.getProperty(DATA_SOURCE_ID);
        String newDataSourceName = cpProperties.getProperty(DATA_SOURCE_NAME);
        DataSourceDesignSession.ProfileReference profileRef = new DataSourceDesignSession.ProfileReference(cpProperties.getProperty(PROFILE_INSTANCE_ID), new Path(cpProperties.getProperty(STOREAGE_FILE_PATH)).toFile(), false);
        try {
            this.dataSourceDesign = DataSourceDesignSession.createNewDesignFromProfile((String)odaDataSourceID, (String)newDataSourceName, (DataSourceDesignSession.ProfileReference)profileRef).getResponseDataSourceDesign();
            this.dataSourceHandle = new ModelOdaAdapter().createDataSourceHandle(this.dataSourceDesign, (ModuleHandle)this.parentHandle);
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void tearDown() {
        if (this.dataSourceHandle == null) {
            this.createFromConnectionProfile();
        }
        try {
            SlotHandle slotHandle = ((ModuleHandle)this.parentHandle).getDataSources();
            slotHandle.add((DesignElementHandle)this.dataSourceHandle);
        }
        catch (SemanticException e) {
            this.getActivityStack().rollback();
            ExceptionHandler.handle(e);
        }
        this.resetCPWizard();
        this.getActivityStack().commit();
    }

    private void resetCPWizard() {
        instance = null;
    }

    private CommandStack getActivityStack() {
        return Utility.getCommandStack();
    }
}

