/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import org.eclipse.birt.report.designer.data.ui.dataset.PropertyPageWrapper;
import org.eclipse.birt.report.designer.data.ui.datasource.PropertyBindingPage;
import org.eclipse.birt.report.designer.data.ui.property.AbstractPropertyDialog;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSourceEditor
extends AbstractPropertyDialog
implements IPreferencePageContainer {
    private DataSourceDesignSession m_designSession = null;
    private OdaDataSourceHandle dataSourceHandle = null;
    private PropertyPageWrapper propertyPageWrapper = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataSourceEditor(Shell parentShell, DataSourceHandle ds) {
        super(parentShell, ds);
        String dataSourceType = null;
        if (ds instanceof OdaDataSourceHandle) {
            this.dataSourceHandle = (OdaDataSourceHandle)ds;
            if (!$assertionsDisabled && this.dataSourceHandle == null) {
                throw new AssertionError();
            }
            dataSourceType = this.dataSourceHandle.getExtensionID();
        }
        if (DesignSessionUtil.hasValidOdaDesignUIExtension(dataSourceType)) {
            this.addCustomPageODAV3(this.dataSourceHandle);
        } else {
            IConfigurationElement element = DataSetProvider.findDataSourceElement(dataSourceType);
            if (element != null) {
                this.addCustomPageODAV2(element);
            }
        }
        this.addPageTo("/", "org.eclipse.birt.datasource.editor.property", Messages.getString((String)"datasource.editor.property"), null, new PropertyBindingPage());
    }

    private void addCustomPageODAV3(OdaDataSourceHandle dataSourceHandle) {
        try {
            DesignSessionRequest designSessionRequest = DTPUtil.getInstance().createDesignSessionRequest(dataSourceHandle);
            this.m_designSession = DataSourceDesignSession.startEditDesign((DesignSessionRequest)designSessionRequest);
            this.propertyPageWrapper = new PropertyPageWrapper(this.m_designSession.getEditorPage());
            DataSourceDesign dataSourceDesign = designSessionRequest.getDataSourceDesign();
            this.addPageTo(dataSourceDesign.getLinkedProfileStoreFilePath(), dataSourceDesign.getName(), this.propertyPageWrapper.getPropertyPage().getTitle(), null, this.propertyPageWrapper);
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void addCustomPageODAV2(IConfigurationElement element) {
        try {
            IConfigurationElement[] editorPages = element.getChildren("dataSourceEditorPage");
            if (editorPages != null && editorPages.length > 0 && editorPages != null) {
                for (int n = 0; n < editorPages.length; ++n) {
                    IPropertyPage page = (IPropertyPage)editorPages[n].createExecutableExtension("class");
                    this.addPageTo(editorPages[n].getAttribute("path"), editorPages[n].getAttribute("name"), editorPages[n].getAttribute("displayName"), null, page);
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e);
        }
    }

    public boolean performOk() {
        if (this.m_designSession != null) {
            try {
                DTPUtil.getInstance().updateDataSourceHandle(this.m_designSession.finish().getResponse(), this.dataSourceHandle);
            }
            catch (OdaException e) {
                ExceptionHandler.handle(e);
            }
        }
        return true;
    }

    public boolean performCancel() {
        if (this.m_designSession != null) {
            this.m_designSession.cancel();
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        String title = Messages.getFormattedString((String)"datasource.edit", (Object[])new String[]{((DataSourceHandle)this.getModel()).getName()});
        this.getShell().setText(title);
        Control control = super.createContents(parent);
        Utility.setSystemHelp(control, "org.eclipse.birt.cshelp.Dialog_DatasourceEdit_ID");
        return control;
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(this.propertyPageWrapper.getPropertyPage().isValid());
        }
    }

    public void updateMessage() {
        PropertyPage propertyPage = this.propertyPageWrapper.getPropertyPage();
        this.setMessage(propertyPage.getMessage(), propertyPage.getMessageType());
    }

    public void updateTitle() {
    }

    static {
        $assertionsDisabled = !DataSourceEditor.class.desiredAssertionStatus();
    }
}

