/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseDialog
extends TrayDialog {
    private String title;
    private String okLabel = null;
    protected Object result;

    protected BaseDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    protected BaseDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        if (this.initDialog()) {
            if (Policy.TRACING_DIALOGS) {
                String[] result = ((Object)((Object)this)).getClass().getName().split("\\.");
                System.out.println("Dialog >> Open " + result[result.length - 1]);
            }
            return super.open();
        }
        return 1;
    }

    protected boolean initDialog() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (this.getShell() != null) {
            this.getShell().setText(newTitle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    protected Button getOkButton() {
        return this.getButton(0);
    }

    public void setOKLabel(String label) {
        this.okLabel = label;
    }

    public Object getResult() {
        return this.result;
    }

    protected final void setResult(Object value) {
        this.result = value;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (0 == id && this.okLabel != null) {
            return super.createButton(parent, id, this.okLabel, defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }
}

