/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboBoxFieldEditor
extends AbstractFieldEditor {
    private Combo fCombo;
    private String[][] fEntryNamesAndValues;

    public ComboBoxFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        for (int i = 0; i < table.length; ++i) {
            String[] array = table[i];
            if (array != null && array.length == 2) continue;
            return false;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = 1;
            --numColumns;
        }
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
            }
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ComboBoxFieldEditor.this.valueChanged("field_editor_value");
                }
            });
        }
        return this.fCombo;
    }

    protected String getValueForName(String name) {
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (!name.equals(entry[0])) continue;
            return entry[1];
        }
        return name;
    }

    protected void updateComboForValue(String value) {
        this.setOldValue(value);
        for (int i = 0; i < this.fEntryNamesAndValues.length; ++i) {
            if (!this.fEntryNamesAndValues[i][1].equals(value)) continue;
            this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
            return;
        }
        if (value == null) {
            this.fCombo.setText("");
        } else {
            this.fCombo.setText(value);
        }
        this.setOldValue(this.getStringValue());
    }

    protected String getStringValue() {
        if (this.fCombo != null) {
            return this.getValueForName(this.fCombo.getText());
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }
}

