/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.FormatStringPattern;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatStringPage
extends Composite
implements IFormatPage {
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatStringPage.previewText.invalidFormatCode");
    private static final String LABEL_FORMAT_STRING_PAGE = Messages.getString((String)"FormatStringPage.label.formatStringAs");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatStringPage.label.previewWithFormat");
    private static final String LABEL_CUSTOM_SETTINGS_GROUP = Messages.getString((String)"FormatStringPage.label.customSettings");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatStringPage.label.format.code");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatStringPage.label.table.collumn.exampleFormatCode");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatStringPage.label.table.collumn.exampleFormatResult");
    private static final String LABEL_CUSTOM_PREVIEW_LABEL = Messages.getString((String)"FormatStringPage.label.custom.preview.label");
    private static final String LABEL_CUSTOM_PREVIEW_GROUP = Messages.getString((String)"FormatStringPage.label.preview.group");
    private static final String LABEL_CUSTOM_SETTING_TEXT = Messages.getString((String)"FormatStringPage.label.custom.settings.label");
    private static final String LABEL_CUSTOM_PREVIEW_STRING = Messages.getString((String)"FormatStringPage.label.preview.string");
    private static final String SAMPLE_TEXT_ZIP_CODE = Messages.getString((String)"FormatStringPage.SimpleTextZipCode");
    private static final String SAMPLE_TEXT_ZIP_C0DE4 = Messages.getString((String)"FormatStringPage.SimpleTextZipCode4");
    private static final String SAMPLE_TEXT_PHONE_NUMBER = Messages.getString((String)"FormatStringPage.PhoneNumber");
    private static final String SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER = Messages.getString((String)"FormatStringPage.SocialSecurityNumber");
    private static final String DEFAULT_PREVIEW_TEXT = Messages.getString((String)"FormatStringPage.default.preview.text");
    ULocale DEFAULT_LOCALE = ULocale.getDefault();
    private String pattern = null;
    private String category = null;
    private String oldCategory = null;
    private String oldPattern = null;
    private HashMap categoryPageMaps;
    private static String[][] choiceArray = null;
    private static String[] formatTypes = null;
    private static final int FORMAT_TYPE_INDEX = 0;
    private static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private Combo typeChoicer;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalPage;
    private Composite customPage;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    private Label generalPreviewLabel;
    private Label cPreviewLabel;
    private Text formatCode;
    private Text previewTextBox;
    private boolean hasLoaded = false;
    private String previewText = null;
    private boolean isDirty = false;
    private List listeners = new ArrayList();
    private int pageAlignment;
    private Table table;

    public FormatStringPage(Composite parent, int style) {
        this(parent, style, 0);
    }

    public FormatStringPage(Composite parent, int style, int pageAlignment) {
        super(parent, style);
        this.pageAlignment = pageAlignment;
        this.createContents(pageAlignment);
    }

    protected void createContents(int pageAlignment) {
        this.initChoiceArray();
        this.getFormatTypes();
        if (pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
    }

    protected void createContentsVirtically() {
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite((Composite)this, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        new Label(topContainer, 0).setText(LABEL_FORMAT_STRING_PAGE);
        this.typeChoicer = new Combo(topContainer, 8);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatStringPage.this.reLayoutSubPages();
                FormatStringPage.this.updatePreview();
                FormatStringPage.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.getFormatTypes());
        this.infoComp = new Composite((Composite)this, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    protected void createContentsHorizontally() {
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        Composite container = new Composite((Composite)this, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        new Label(container, 0).setText(LABEL_FORMAT_STRING_PAGE);
        this.typeChoicer = new Combo(container, 8);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatStringPage.this.reLayoutSubPages();
                FormatStringPage.this.updatePreview();
                FormatStringPage.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.getFormatTypes());
        this.infoComp = new Composite((Composite)this, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite((Composite)this, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    private void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put("Unformatted", this.getGeneralPage(parent));
        this.categoryPageMaps.put(">", this.getGeneralPage(parent));
        this.categoryPageMaps.put("<", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Custom", this.getCustomPage(parent));
    }

    private void createFormatCodePages(Composite parent) {
        this.getHorizonGeneralFormatCodePage(parent);
        this.getHorizonCustomFormatCodePage(parent);
    }

    private String[][] initChoiceArray() {
        if (choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet("StringFormatValue", "category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                choiceArray = new String[4][2];
                int j = 0;
                for (int i = 0; i < choices.length; ++i) {
                    if (!choices[i].getName().equals("Unformatted") && !choices[i].getName().equals(">") && !choices[i].getName().equals("<") && !choices[i].getName().equals("Custom")) continue;
                    FormatStringPage.choiceArray[j][0] = choices[i].getDisplayName();
                    FormatStringPage.choiceArray[j][1] = choices[i].getName();
                    ++j;
                }
            } else {
                choiceArray = new String[0][0];
            }
        }
        return choiceArray;
    }

    private String[] getFormatTypes() {
        if (this.initChoiceArray() != null) {
            formatTypes = new String[choiceArray.length];
            for (int i = 0; i < choiceArray.length; ++i) {
                FormatStringPage.formatTypes[i] = choiceArray[i][0];
            }
        } else {
            formatTypes = new String[0];
        }
        return formatTypes;
    }

    private int getIndexOfCategory(String name) {
        if (choiceArray != null) {
            for (int i = 0; i < choiceArray.length; ++i) {
                if (!choiceArray[i][1].equals(name)) continue;
                return i;
            }
        }
        return 0;
    }

    private String getCategory4DisplayName(String displayName) {
        if (choiceArray != null) {
            for (int i = 0; i < choiceArray.length; ++i) {
                if (!choiceArray[i][0].equals(displayName)) continue;
                return choiceArray[i][1];
            }
        }
        return displayName;
    }

    private String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName("StringFormatValue", "category", category);
    }

    private void fireFormatChanged(String newCategory, String newPattern) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent(this, "stringFormat", newCategory, newPattern);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object listener = iter.next();
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    private void notifyFormatChange() {
        if (this.hasLoaded) {
            this.fireFormatChanged(this.getCategory(), this.getPattern());
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (StringUtil.isBlank((String)fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr);
    }

    public void setInput(String categoryStr, String patternStr) {
        this.hasLoaded = false;
        this.initiatePageLayout(categoryStr, patternStr);
        this.reLayoutSubPages();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.hasLoaded = true;
    }

    public void setPreviewText(String preText) {
        if (preText == null) {
            this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        } else {
            this.previewTextBox.setText(preText);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return "Unformatted";
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return this.category + ":" + this.pattern;
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        return this.oldPattern == null ? p != null : !this.oldPattern.equals(p);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setControlsEnabeld(enabled);
    }

    private String getPreviewText() {
        return this.previewText;
    }

    private void setCategory(String category) {
        this.category = category;
    }

    private void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void setDefaultPreviewText(String defText) {
        this.previewText = defText == null || StringUtil.isBlank((String)defText) ? null : defText;
    }

    private void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    private void updatePreview() {
        this.markDirty(this.hasLoaded);
        String gText = this.getPreviewText() == null ? DEFAULT_PREVIEW_TEXT : this.getPreviewText();
        String category = this.getCategory4DisplayName(this.typeChoicer.getText());
        this.setCategory(category);
        if ("Unformatted".equals(category)) {
            String pattern = null;
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(null);
        } else if (">".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("<".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Zip Code".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_ZIP_CODE);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Zip Code + 4".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_ZIP_C0DE4);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Phone Number".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_PHONE_NUMBER);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Social Security Number".equals(category)) {
            String pattern = FormatStringPattern.getPatternForCategory((String)category);
            gText = SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER;
            String fmtStr = new StringFormatter(pattern, this.DEFAULT_LOCALE).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else if ("Custom".equals(category)) {
            String pattern = this.formatCode.getText();
            String fmtStr = StringUtil.isBlank((String)this.previewTextBox.getText()) ? new StringFormatter(pattern, this.DEFAULT_LOCALE).format(gText) : new StringFormatter(pattern, this.DEFAULT_LOCALE).format(this.previewTextBox.getText());
            this.cPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        }
    }

    private void initiatePageLayout(String categoryStr, String patternStr) {
        if (categoryStr == null) {
            this.typeChoicer.select(0);
        } else {
            if (categoryStr.equals("Custom")) {
                this.formatCode.setText(patternStr == null ? "" : patternStr);
            }
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        }
    }

    private void reLayoutSubPages() {
        Control control;
        String category = this.getCategory4DisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = (Control)this.categoryPageMaps.get(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals("Custom") ? this.getHorizonCustomFormatCodePage(this.formatCodeComp) : this.getHorizonGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.generalPreviewLabel = this.createGeneralPreviewPart(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCustomPage(Composite parent) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                new Label(container, 0).setText(LABEL_FORMAT_CODE);
                this.formatCode = new Text(container, 2052);
                this.formatCode.setLayoutData((Object)new GridData(768));
                this.formatCode.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (FormatStringPage.this.hasLoaded) {
                            FormatStringPage.this.updatePreview();
                        }
                    }
                });
                this.formatCode.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        FormatStringPage.this.notifyFormatChange();
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
            this.createCustomPreviewPart(this.customPage);
        }
        return this.customPage;
    }

    private Composite getHorizonGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = new Label(this.generalFormatCodePage, 258);
            l.setLayoutData((Object)new GridData(768));
        }
        return this.generalFormatCodePage;
    }

    private Composite getHorizonCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = new Label(this.customFormatCodePage, 258);
            l.setLayoutData((Object)new GridData(768));
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            new Label(container, 0).setText(LABEL_FORMAT_CODE);
            this.formatCode = new Text(container, 2052);
            this.formatCode.setLayoutData((Object)new GridData(768));
            this.formatCode.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FormatStringPage.this.hasLoaded) {
                        FormatStringPage.this.updatePreview();
                    }
                }
            });
            this.formatCode.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FormatStringPage.this.notifyFormatChange();
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.customFormatCodePage;
    }

    private Label createGeneralPreviewPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewText = new Label((Composite)group, 0x1000300);
        previewText.setLayoutData((Object)new GridData(768));
        return previewText;
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_CUSTOM_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_CUSTOM_SETTING_TEXT);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_CUSTOM_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        new Label((Composite)group, 0).setText(LABEL_CUSTOM_PREVIEW_STRING);
        this.previewTextBox = new Text((Composite)group, 2052);
        this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.previewTextBox.setLayoutData((Object)data);
        this.previewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatStringPage.this.setDefaultPreviewText(FormatStringPage.this.previewTextBox.getText());
                if (FormatStringPage.this.hasLoaded) {
                    FormatStringPage.this.updatePreview();
                }
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_CUSTOM_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.cPreviewLabel = new Label((Composite)group, 0x11000100);
        this.cPreviewLabel.setText("");
        data = new GridData(1808);
        data.horizontalSpan = 1;
        this.cPreviewLabel.setLayoutData((Object)data);
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 100352);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = ((TableItem)e.item).getText(0);
                String category = ChoiceSetFactory.getStructPropValue("StringFormatValue", "category", displayName);
                String pattern = FormatStringPattern.getPatternForCategory((String)category);
                FormatStringPage.this.formatCode.setText(pattern);
                FormatStringPage.this.updatePreview();
                FormatStringPage.this.notifyFormatChange();
            }
        });
        TableColumn tableColumValue = new TableColumn(this.table, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumValue.setWidth(120);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.table, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(120);
        tableColumnDisplay.setResizable(true);
        new TableItem(this.table, 0).setText(new String[]{this.getDisplayName4Category(">"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)">"), this.DEFAULT_LOCALE).format(DEFAULT_PREVIEW_TEXT)});
        new TableItem(this.table, 0).setText(new String[]{this.getDisplayName4Category("<"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"<"), this.DEFAULT_LOCALE).format(DEFAULT_PREVIEW_TEXT)});
        new TableItem(this.table, 0).setText(new String[]{this.getDisplayName4Category("Zip Code + 4"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Zip Code + 4"), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_ZIP_C0DE4)});
        new TableItem(this.table, 0).setText(new String[]{this.getDisplayName4Category("Phone Number"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Phone Number"), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_PHONE_NUMBER)});
        new TableItem(this.table, 0).setText(new String[]{this.getDisplayName4Category("Social Security Number"), new StringFormatter(FormatStringPattern.getPatternForCategory((String)"Social Security Number"), this.DEFAULT_LOCALE).format(SAMPLE_TEXT_SOCIAL_SECURITY_NUMBER)});
    }

    private GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    private GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    private void setControlsEnabeld(boolean b) {
        this.typeChoicer.setEnabled(b);
        this.formatCode.setEnabled(b);
        this.previewTextBox.setEnabled(b);
        this.table.setEnabled(b);
    }
}

