/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BooleanFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SeparatorFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GeneralPreferencePage
extends BaseStylePreferencePage {
    private Object model;
    private Combo preName;
    private Text cusName;
    private Button preStyle;
    private Button cusStyle;
    private int selectedType = -1;
    private static final int TYPE_PREDEFINED = 0;
    private static final int TYPE_CUSTOM = 1;

    public GeneralPreferencePage(Object model) {
        super(model);
        this.model = model;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        this.createStyleNameControl();
        this.addField(new SeparatorFieldEditor(this.getFieldEditorParent()));
        BooleanFieldEditor shrink = new BooleanFieldEditor("canShrink", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("canShrink").getDefn().getDisplayNameID()), this.getFieldEditorParent());
        this.addField(shrink);
        BooleanFieldEditor blank = new BooleanFieldEditor("showIfBlank", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("showIfBlank").getDefn().getDisplayNameID()), this.getFieldEditorParent());
        this.addField(blank);
        UIUtil.bindHelp((Control)this.getFieldEditorParent().getParent(), "org.eclipse.birt.cshelp.StyleBuilderGeneral_ID");
    }

    private void createStyleNameControl() {
        Composite nameComp = new Composite(this.getFieldEditorParent(), 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        nameComp.setLayoutData((Object)data);
        nameComp.setLayout((Layout)new GridLayout(2, false));
        this.preStyle = new Button(nameComp, 16);
        this.preStyle.setText(Messages.getString((String)"GeneralPreferencePage.label.predefinedStyle"));
        this.preStyle.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.setPredefinedStyle(true);
                GeneralPreferencePage.this.preName.setFocus();
                if (GeneralPreferencePage.this.preName.getSelectionIndex() == -1) {
                    GeneralPreferencePage.this.preName.select(0);
                }
                GeneralPreferencePage.this.selectedType = 0;
            }
        });
        this.preName = new Combo(nameComp, 8);
        data = new GridData(768);
        this.preName.setLayoutData((Object)data);
        this.preName.setItems(this.getPredefinedStyeNames());
        this.cusStyle = new Button(nameComp, 16);
        this.cusStyle.setText(Messages.getString((String)"GeneralPreferencePage.label.customStyle"));
        this.cusStyle.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.setPredefinedStyle(false);
                GeneralPreferencePage.this.cusName.setFocus();
                GeneralPreferencePage.this.selectedType = 1;
            }
        });
        this.cusName = new Text(nameComp, 2052);
        data = new GridData(768);
        this.cusName.setLayoutData((Object)data);
        this.cusName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
    }

    private String[] getPredefinedStyeNames() {
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        if (preStyles == null) {
            return new String[0];
        }
        Object[] names = new String[preStyles.size()];
        for (int i = 0; i < preStyles.size(); ++i) {
            names[i] = ((PredefinedStyle)preStyles.get(i)).getName();
        }
        Arrays.sort(names);
        return names;
    }

    protected void initialize() {
        if (this.model instanceof StyleHandle) {
            if (((StyleHandle)this.model).isPredefined()) {
                this.preStyle.setSelection(true);
                this.setPredefinedStyle(true);
                this.preName.setText(((StyleHandle)this.model).getName());
            } else {
                this.cusStyle.setSelection(true);
                this.setPredefinedStyle(false);
                this.cusName.setText(((StyleHandle)this.model).getName());
            }
        }
        super.initialize();
    }

    private void setPredefinedStyle(boolean b) {
        this.preName.setEnabled(b);
        this.cusName.setEnabled(!b);
    }

    public boolean performOk() {
        if (this.storeName()) {
            return super.performOk();
        }
        this.cusName.setFocus();
        return false;
    }

    private boolean storeName() {
        IPreferenceStore ps = this.getPreferenceStore();
        ((StylePreferenceStore)ps).clearError();
        if (!this.checkName(this.getName())) {
            return false;
        }
        this.getPreferenceStore().setValue("name", this.getName());
        return !((StylePreferenceStore)ps).hasError();
    }

    private boolean checkName(String name) {
        if (((StyleHandle)this.model).isPredefined() && this.selectedType == 1) {
            Iterator iterator = DEUtil.getStyles();
            while (iterator.hasNext()) {
                SharedStyleHandle handle = (SharedStyleHandle)iterator.next();
                if (!handle.getName().equals(name)) continue;
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"GeneralPreferencePage.errorMsg.duplicate.styleName"), Messages.getString((String)"GeneralPreferencePage.label.styleName") + ": \"" + name + "\" " + Messages.getString((String)"GeneralPreferencePage.label.choose.different.name"));
                return false;
            }
        }
        return true;
    }

    private String getName() {
        if (this.preStyle.getSelection()) {
            return this.preName.getText();
        }
        return this.cusName.getText();
    }
}

