/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportValueDialog
extends BaseDialog {
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private static final String DLG_TITLE = Messages.getString((String)"ImportValueDialog.Title");
    private static final String LABEL_SELECT_DATASET = Messages.getString((String)"ImportValueDialog.Label.SelectDataSet");
    private static final String LABEL_SELECT_COLUMN = Messages.getString((String)"ImportValueDialog.Label.SelectColumn");
    private static final String LABEL_SELECT_VALUE = Messages.getString((String)"ImportValueDialog.Label.SelectValue");
    private static final String DATE_TIME_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    private Combo dataSetChooser;
    private Combo columnChooser;
    private Text valueEditor;
    private org.eclipse.swt.widgets.List valueList;
    private org.eclipse.swt.widgets.List selectedList;
    private Button add;
    private Button addAll;
    private Button remove;
    private Button removeAll;
    private String currentDataSetName;
    private ArrayList resultList = new ArrayList();
    private List columnList;
    private int selectedColumnIndex;
    private DataEngine engine;
    private String style;

    public ImportValueDialog(String style) {
        super(DLG_TITLE);
        Assert.isTrue((boolean)DATA_TYPE_CHOICE_SET.contains(style));
        this.style = style;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createColumnSelectionArea(composite);
        this.createValueSelectionArea(composite);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.ImportValueDialog_ID");
        return composite;
    }

    private void createColumnSelectionArea(Composite parent) {
        Composite selectionArea = new Composite(parent, 0);
        selectionArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        selectionArea.setLayoutData((Object)new GridData(768));
        new Label(selectionArea, 0).setText(LABEL_SELECT_DATASET);
        this.dataSetChooser = new Combo(selectionArea, 12);
        this.dataSetChooser.setLayoutData((Object)new GridData(768));
        this.dataSetChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSelection = ImportValueDialog.this.dataSetChooser.getText();
                if (!ImportValueDialog.this.currentDataSetName.equals(newSelection)) {
                    ImportValueDialog.this.currentDataSetName = newSelection;
                    ImportValueDialog.this.refreshColumns();
                }
            }
        });
        new Label(selectionArea, 0).setText(LABEL_SELECT_COLUMN);
        this.columnChooser = new Combo(selectionArea, 12);
        this.columnChooser.setLayoutData((Object)new GridData(768));
        this.columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSelectedIndex = ImportValueDialog.this.columnChooser.getSelectionIndex();
                if (ImportValueDialog.this.selectedColumnIndex != newSelectedIndex) {
                    ImportValueDialog.this.selectedColumnIndex = newSelectedIndex;
                    ImportValueDialog.this.refreshValues();
                }
            }
        });
    }

    private void createValueSelectionArea(Composite parent) {
        Composite selectionArea = new Composite(parent, 0);
        selectionArea.setLayout((Layout)new GridLayout(3, false));
        selectionArea.setLayoutData((Object)new GridData(768));
        Composite subComposite = new Composite(selectionArea, 0);
        subComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        subComposite.setLayoutData((Object)new GridData(768));
        new Label(subComposite, 0).setText(LABEL_SELECT_VALUE);
        this.valueEditor = new Text(subComposite, 2052);
        this.valueEditor.setLayoutData((Object)new GridData(768));
        this.valueEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportValueDialog.this.filteValues();
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        new Label(selectionArea, 0).setLayoutData((Object)gd);
        this.valueList = new org.eclipse.swt.widgets.List(selectionArea, 2818);
        this.setListLayoutData(this.valueList);
        this.valueList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportValueDialog.this.addSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.updateButtons();
            }
        });
        Composite buttonBar = new Composite(selectionArea, 0);
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin();
        buttonBar.setLayout((Layout)layout);
        this.addAll = new Button(buttonBar, 8);
        this.addAll.setText(">>");
        this.addAll.setLayoutData((Object)new GridData(1816));
        this.addAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.addAll();
            }
        });
        this.add = new Button(buttonBar, 8);
        this.add.setText(">");
        this.add.setLayoutData((Object)new GridData(768));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.addSelected();
            }
        });
        this.remove = new Button(buttonBar, 8);
        this.remove.setText("<");
        this.remove.setLayoutData((Object)new GridData(768));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.removeSelected();
            }
        });
        this.removeAll = new Button(buttonBar, 8);
        this.removeAll.setText("<<");
        this.removeAll.setLayoutData((Object)new GridData(1810));
        this.removeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.removeAll();
            }
        });
        this.selectedList = new org.eclipse.swt.widgets.List(selectionArea, 2818);
        this.setListLayoutData(this.selectedList);
        this.selectedList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportValueDialog.this.removeSelected();
            }

            public void widgetSelected(SelectionEvent e) {
                ImportValueDialog.this.updateButtons();
            }
        });
    }

    private void setListLayoutData(org.eclipse.swt.widgets.List list) {
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 200;
        list.setLayoutData((Object)gd);
    }

    private void addSelected() {
        String[] selected = this.valueList.getSelection();
        int selectedIndex = this.valueList.getSelectionIndex();
        int oldListSize = this.valueList.getItemCount();
        if (selected.length == 0) {
            selected = new String[]{this.valueEditor.getText()};
        }
        for (int i = 0; i < selected.length; ++i) {
            if (this.selectedList.indexOf(selected[i]) != -1) continue;
            this.selectedList.add(selected[i]);
        }
        this.filteValues();
        if (selected.length == 1) {
            int nextSelected = selectedIndex + 1 < oldListSize ? selectedIndex : selectedIndex - 1;
            this.valueList.select(nextSelected);
        } else if (selected.length > 1 && this.valueList.getItemCount() > 0) {
            this.valueList.select(0);
        }
        this.updateButtons();
    }

    private void addAll() {
        String[] values = this.valueList.getItems();
        for (int i = 0; i < values.length; ++i) {
            if (this.selectedList.indexOf(values[i]) != -1) continue;
            this.selectedList.add(values[i]);
        }
        this.filteValues();
    }

    private void removeSelected() {
        int selectedIndex = this.selectedList.getSelectionIndex();
        int oldListSize = this.selectedList.getItemCount();
        String[] selected = this.selectedList.getSelection();
        for (int i = 0; i < selected.length; ++i) {
            this.selectedList.remove(selected[i]);
        }
        this.filteValues();
        if (selected.length == 1) {
            int nextSelected = selectedIndex + 1 < oldListSize ? selectedIndex : selectedIndex - 1;
            this.selectedList.select(nextSelected);
        } else if (selected.length > 1 && this.valueList.getItemCount() > 0) {
            this.selectedList.select(0);
        }
        this.updateButtons();
    }

    private void removeAll() {
        this.selectedList.removeAll();
        this.filteValues();
    }

    protected boolean initDialog() {
        try {
            this.engine = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, null, null, null));
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        this.dataSetChooser.setItems(ChoiceSetFactory.getDataSets());
        this.dataSetChooser.select(0);
        this.currentDataSetName = this.dataSetChooser.getText();
        this.refreshColumns();
        return true;
    }

    private void refreshColumns() {
        DataSetHandle dataSetHandle = this.getDataSetHandle();
        try {
            this.columnList = DataUtil.getColumnList(dataSetHandle);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        this.columnChooser.removeAll();
        this.selectedColumnIndex = -1;
        if (this.columnList.size() == 0) {
            this.columnChooser.setItems(new String[0]);
        } else {
            ArrayList<ResultSetColumnHandle> matachedColumnList = new ArrayList<ResultSetColumnHandle>();
            Iterator iter = this.columnList.iterator();
            while (iter.hasNext()) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                if (!this.matchType(column)) continue;
                this.columnChooser.add(column.getColumnName());
                matachedColumnList.add(column);
                this.selectedColumnIndex = 0;
            }
        }
        this.columnChooser.select(this.selectedColumnIndex);
        this.columnChooser.setEnabled(this.selectedColumnIndex == 0);
        this.refreshValues();
    }

    private boolean matchType(ResultSetColumnHandle column) {
        if (this.style.equals("string") || "any".equals(column.getDataType())) {
            return true;
        }
        if ("date-time".equals(column.getDataType())) {
            return this.style.equals("dateTime");
        }
        if ("decimal".equals(column.getDataType())) {
            return this.style.equals("decimal") || this.style.equals("integer");
        }
        if ("float".equals(column.getDataType())) {
            return this.style.equals("float");
        }
        if ("integer".equals(column.getDataType())) {
            return this.style.equals("integer");
        }
        return false;
    }

    private void refreshValues() {
        this.resultList.clear();
        if (this.columnChooser.isEnabled()) {
            ResultSetColumnHandle selectedColumn = null;
            try {
                BaseQueryDefinition query = (BaseQueryDefinition)DataUtil.getPreparedQuery(this.engine, this.getDataSetHandle()).getReportQueryDefn();
                String queryExpr = null;
                Iterator iter = this.columnList.iterator();
                while (iter.hasNext()) {
                    ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                    if (!column.getColumnName().equals(this.columnChooser.getText())) continue;
                    queryExpr = DEUtil.getResultSetColumnExpression((String)column.getColumnName());
                    selectedColumn = column;
                    break;
                }
                if (queryExpr == null) {
                    return;
                }
                ScriptExpression expression = new ScriptExpression(queryExpr);
                String columnBindingName = "_$_COLUMNBINDINGNAME_$_";
                query.addResultSetExpression(columnBindingName, (IBaseExpression)expression);
                IPreparedQuery preparedQuery = this.engine.prepare((IQueryDefinition)query);
                IQueryResults results = preparedQuery.execute(null);
                if (results != null) {
                    IResultIterator iter2 = results.getResultIterator();
                    if (iter2 != null) {
                        DateFormatter formatter = new DateFormatter(DATE_TIME_PATTERN, ULocale.US);
                        while (iter2.next()) {
                            String result = null;
                            result = "date-time".equals(selectedColumn.getDataType()) ? formatter.format(iter2.getDate(columnBindingName)) : iter2.getString(columnBindingName);
                            if (StringUtil.isBlank((String)result) || this.resultList.contains(result)) continue;
                            this.resultList.add(result);
                        }
                    }
                    results.close();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
                this.valueList.removeAll();
                this.valueList.deselectAll();
                this.updateButtons();
            }
            this.filteValues();
        } else {
            this.valueList.removeAll();
            this.valueList.deselectAll();
            this.updateButtons();
        }
    }

    private void filteValues() {
        this.valueList.removeAll();
        this.valueList.deselectAll();
        Iterator itor = this.resultList.iterator();
        while (itor.hasNext()) {
            String value = (String)itor.next();
            try {
                if (this.selectedList.indexOf(value) != -1 || !value.startsWith(this.valueEditor.getText().trim()) && !value.matches(this.valueEditor.getText().trim())) continue;
                this.valueList.add(value);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.add.setEnabled(this.valueList.getSelectionCount() != 0 || this.valueEditor.getText().trim().length() != 0 && this.selectedList.indexOf(this.valueEditor.getText().trim()) == -1);
        this.addAll.setEnabled(this.valueList.getItemCount() != 0);
        this.remove.setEnabled(this.selectedList.getSelectionCount() != 0);
        this.removeAll.setEnabled(this.selectedList.getItemCount() != 0);
        this.getOkButton().setEnabled(this.selectedList.getItemCount() != 0);
    }

    protected void okPressed() {
        this.setResult(this.selectedList.getItems());
        super.okPressed();
    }

    private DataSetHandle getDataSetHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(this.currentDataSetName);
    }

    public boolean close() {
        if (this.engine != null) {
            this.engine.shutdown();
        }
        return super.close();
    }
}

