/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ResourceEditDialog
extends BaseDialog {
    private Label nameLabel;
    private TableViewer viewer;
    private Text keyText;
    private Text valueText;
    private Button btnDelete;
    private Properties content = new Properties();
    private String propFileName;
    private boolean column1desc;
    private boolean column2desc;
    private boolean listChanged;
    private URL resourceURL;
    private Button btnAdd;

    public ResourceEditDialog(Shell parentShell, String title) {
        super(parentShell, title);
        this.setShellStyle(67696);
        this.listChanged = false;
    }

    public void setResourceURL(URL url) {
        this.resourceURL = url;
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.y = Math.max(pt.y, 400);
        this.getShell().setSize(pt);
        this.updateButtonState();
    }

    private void loadMessage() {
        if (this.resourceURL != null) {
            try {
                InputStream in = this.resourceURL.openStream();
                this.content.load(in);
                in.close();
                this.propFileName = this.resourceURL.getPath();
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private boolean saveMessage() {
        if (this.resourceURL != null) {
            if (this.resourceURL.getProtocol().equals("file") && this.listChanged) {
                return this.saveFile(this.resourceURL.getPath());
            }
            return true;
        }
        return false;
    }

    private boolean saveFile(String filePath) {
        File f = new File(filePath);
        if (!f.exists() || !f.isFile()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.NotFile.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.NotFile.Message", (Object[])new Object[]{this.propFileName}));
            return false;
        }
        if (!f.canWrite()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.ReadOnlyEncounter.Message", (Object[])new Object[]{this.propFileName}));
            return false;
        }
        try {
            if (f.canWrite()) {
                FileOutputStream fos = new FileOutputStream(f);
                this.content.store(fos, "");
                fos.close();
            }
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ResourceEditDialog_ID");
        this.loadMessage();
        final Composite innerParent = (Composite)super.createDialogArea(parent);
        this.nameLabel = new Label(innerParent, 0);
        this.nameLabel.setText(Messages.getString((String)"ResourceEditDialog.message.ResourceFile") + this.propFileName);
        this.nameLabel.setLayoutData((Object)new GridData(768));
        final Table table = new Table(innerParent, 67584);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString((String)"ResourceEditDialog.text.Key"));
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceEditDialog.this.viewer.setSorter((ViewerSorter)new ResourceSorter(ResourceEditDialog.this.column1desc, false));
                ResourceEditDialog.this.column1desc = !ResourceEditDialog.this.column1desc;
            }
        });
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString((String)"ResourceEditDialog.text.Value"));
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceEditDialog.this.viewer.setSorter((ViewerSorter)new ResourceSorter(ResourceEditDialog.this.column2desc, true));
                ResourceEditDialog.this.column2desc = !ResourceEditDialog.this.column2desc;
            }
        });
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Properties) {
                    return ((Properties)inputElement).entrySet().toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceEditDialog.this.updateSelection();
            }
        });
        innerParent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = innerParent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(2 * width / 5);
                    column2.setWidth(width - column1.getWidth());
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(2 * width / 5);
                    column2.setWidth(width - column1.getWidth());
                }
            }
        });
        Group gp = new Group(innerParent, 0);
        gp.setText(Messages.getString((String)"ResourceEditDialog.text.QuickAdd"));
        gp.setLayoutData((Object)new GridData(768));
        gp.setLayout((Layout)new GridLayout(4, false));
        Label lb = new Label((Composite)gp, 0);
        lb.setText(Messages.getString((String)"ResourceEditDialog.text.Key"));
        lb = new Label((Composite)gp, 0);
        lb.setText(Messages.getString((String)"ResourceEditDialog.text.Value"));
        lb = new Label((Composite)gp, 0);
        lb = new Label((Composite)gp, 0);
        this.keyText = new Text((Composite)gp, 2052);
        this.keyText.setLayoutData((Object)new GridData(768));
        this.valueText = new Text((Composite)gp, 2052);
        this.valueText.setLayoutData((Object)new GridData(768));
        this.btnAdd = new Button((Composite)gp, 8);
        this.btnAdd.setText(Messages.getString((String)"ResourceEditDialog.text.Add"));
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceEditDialog.this.addSelection();
            }
        });
        this.btnAdd.setEnabled(this.isFileSystemFile());
        this.btnDelete = new Button((Composite)gp, 8);
        this.btnDelete.setText(Messages.getString((String)"ResourceEditDialog.text.Delete"));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceEditDialog.this.deleteSelection();
            }
        });
        lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"ResourceEditDialog.message.AddNote"));
        lb.setLayoutData((Object)new GridData(768));
        this.viewer.setInput((Object)this.content);
        return innerParent;
    }

    private void updateSelection() {
        if (this.viewer.getTable().getSelectionCount() > 0) {
            this.keyText.setText(this.viewer.getTable().getSelection()[0].getText(0));
            this.valueText.setText(this.viewer.getTable().getSelection()[0].getText(1));
        }
        this.updateButtonState();
    }

    private void addSelection() {
        File f = new File(this.propFileName);
        if (!f.exists() || !f.isFile()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.NotFile.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.NotFile.Message", (Object[])new Object[]{this.propFileName}));
            return;
        }
        if (!f.canWrite()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.ReadOnlyEncounter.Message", (Object[])new Object[]{this.propFileName}));
            return;
        }
        String key = this.keyText.getText();
        String val = this.valueText.getText();
        if (key != null && key.trim().length() > 0) {
            this.content.put(key, val);
            this.viewer.setInput((Object)this.content);
            this.listChanged = true;
            this.updateSelection();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.text.AddWarningTitle"), (String)Messages.getString((String)"ResourceEditDialog.text.AddWarningMsg"));
        }
    }

    private void deleteSelection() {
        if (this.viewer.getTable().getSelectionIndex() == -1) {
            return;
        }
        File f = new File(this.propFileName);
        if (!f.exists() || !f.isFile()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.NotFile.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.NotFile.Message", (Object[])new Object[]{this.propFileName}));
            return;
        }
        if (!f.canWrite()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"ResourceEditDialog.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"ResourceEditDialog.ReadOnlyEncounter.Message", (Object[])new Object[]{this.propFileName}));
            return;
        }
        this.listChanged = true;
        String key = this.keyText.getText();
        this.content.remove(key);
        this.viewer.getTable().remove(this.viewer.getTable().getSelectionIndex());
        this.updateSelection();
    }

    private void updateButtonState() {
        this.getOkButton().setEnabled(this.viewer.getTable().getSelectionCount() > 0);
        this.btnDelete.setEnabled(this.isFileSystemFile() && this.viewer.getTable().getSelectionIndex() != -1);
    }

    private boolean isFileSystemFile() {
        return this.resourceURL == null || this.resourceURL != null && this.resourceURL.getProtocol().equals("file");
    }

    protected void okPressed() {
        if (this.saveMessage()) {
            this.setResult(this.viewer.getTable().getSelection()[0].getText(0));
        }
        super.okPressed();
    }

    public boolean isKeyValueListChanged() {
        return this.listChanged;
    }

    static class ResourceSorter
    extends ViewerSorter {
        private boolean descent;
        private boolean second;

        public ResourceSorter(boolean descent, boolean second) {
            this.descent = descent;
            this.second = second;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name2;
            String name1;
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                if (this.descent) {
                    name1 = e2.toString();
                    name2 = e1.toString();
                } else {
                    name1 = e1.toString();
                    name2 = e2.toString();
                }
            } else {
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (prov instanceof ITableLabelProvider) {
                    ITableLabelProvider lprov = (ITableLabelProvider)prov;
                    if (this.second) {
                        if (this.descent) {
                            name1 = lprov.getColumnText(e2, 1);
                            name2 = lprov.getColumnText(e1, 1);
                        } else {
                            name1 = lprov.getColumnText(e1, 1);
                            name2 = lprov.getColumnText(e2, 1);
                        }
                    } else if (this.descent) {
                        name1 = lprov.getColumnText(e2, 0);
                        name2 = lprov.getColumnText(e1, 0);
                    } else {
                        name1 = lprov.getColumnText(e1, 0);
                        name2 = lprov.getColumnText(e2, 0);
                    }
                } else if (this.descent) {
                    name1 = e2.toString();
                    name2 = e1.toString();
                } else {
                    name1 = e1.toString();
                    name2 = e2.toString();
                }
            }
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.collator.compare(name1, name2);
        }
    }

    static class PropertyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PropertyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                switch (columnIndex) {
                    case 0: {
                        return String.valueOf(entry.getKey());
                    }
                    case 1: {
                        return String.valueOf(entry.getValue());
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

