/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TableOptionDialog
extends BaseDialog {
    private static final String MSG_DATA_SET = Messages.getString((String)"TableOptionDialog.text.DataSet");
    private static final String MSG_REMEMBER_DIMENSIONS_FOR_NEW_GRIDS = Messages.getString((String)"TableOptionDialog.message.RememberGrid");
    private static final String MSG_REMEMBER_DIMENSIONS_FOR_NEW_TABLES = Messages.getString((String)"TableOptionDialog.message.RememberTable");
    private static final String MSG_NUMBER_OF_GRID_ROWS = Messages.getString((String)"TableOptionDialog.text.GridRow");
    private static final String MSG_NUMBER_OF_TABLE_ROWS = Messages.getString((String)"TableOptionDialog.text.TableDetail");
    private static final String MSG_NUMBER_OF_COLUMNS = Messages.getString((String)"TableOptionDialog.text.Column");
    private static final String MSG_GRID_SIZE = Messages.getString((String)"TableOptionDialog.text.GridSize");
    private static final String MSG_TABLE_SIZE = Messages.getString((String)"TableOptionDialog.text.TableSize");
    private static final String MSG_INSERT_GRID = Messages.getString((String)"TableOptionDialog.title.InsertGrid");
    private static final String MSG_INSERT_TABLE = Messages.getString((String)"TableOptionDialog.title.InsertTable");
    private static final String NONE = Messages.getString((String)"BindingPage.None");
    private static final int DEFAULT_TABLE_ROW_COUNT = 1;
    private static final int DEFAULT_ROW_COUNT = 3;
    private static final int DEFAULT_COLUMN_COUNT = 3;
    public static final String DEFAULT_TABLE_ROW_COUNT_KEY = "Default table row count";
    public static final String DEFAULT_TABLE_COLUMN_COUNT_KEY = "Default table column count";
    public static final String DEFAULT_GRID_ROW_COUNT_KEY = "Default grid row count";
    public static final String DEFAULT_GRID_COLUMN_COUNT_KEY = "Default grid column count";
    private SimpleSpinner rowEditor;
    private SimpleSpinner columnEditor;
    private Button chkbox;
    private int rowCount;
    private int columnCount;
    private boolean insertTable = true;
    private Combo dataSetCombo;

    public TableOptionDialog(Shell parentShell, boolean insertTable) {
        super(parentShell, insertTable ? MSG_INSERT_TABLE : MSG_INSERT_GRID);
        this.insertTable = insertTable;
    }

    private void loadPreference() {
        if (this.insertTable) {
            this.columnCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_TABLE_COLUMN_COUNT_KEY);
            this.rowCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_TABLE_ROW_COUNT_KEY);
        } else {
            this.columnCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_GRID_COLUMN_COUNT_KEY);
            this.rowCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_GRID_ROW_COUNT_KEY);
        }
        if (this.columnCount <= 0) {
            this.columnCount = 3;
        }
        if (this.rowCount <= 0) {
            this.rowCount = this.insertTable ? 1 : 3;
        }
    }

    private void savePreference() {
        if (this.insertTable) {
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_TABLE_COLUMN_COUNT_KEY, this.columnCount);
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_TABLE_ROW_COUNT_KEY, this.rowCount);
        } else {
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_GRID_COLUMN_COUNT_KEY, this.columnCount);
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_GRID_ROW_COUNT_KEY, this.rowCount);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.loadPreference();
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        new Label(composite, 0).setText(this.insertTable ? MSG_TABLE_SIZE : MSG_GRID_SIZE);
        Label sp = new Label(composite, 258);
        sp.setLayoutData((Object)new GridData(768));
        Composite innerPane = new Composite(composite, 0);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 2;
        innerPane.setLayoutData((Object)gdata);
        GridLayout glayout = new GridLayout(2, false);
        glayout.marginWidth = 10;
        innerPane.setLayout((Layout)glayout);
        new Label(innerPane, 0).setText(MSG_NUMBER_OF_COLUMNS);
        this.columnEditor = new SimpleSpinner(innerPane, 0);
        this.columnEditor.setText(String.valueOf(this.columnCount));
        this.columnEditor.setLayoutData(new GridData(768));
        new Label(innerPane, 0).setText(this.insertTable ? MSG_NUMBER_OF_TABLE_ROWS : MSG_NUMBER_OF_GRID_ROWS);
        this.rowEditor = new SimpleSpinner(innerPane, 0);
        this.rowEditor.setText(String.valueOf(this.rowCount));
        this.rowEditor.setLayoutData(new GridData(768));
        if (this.insertTable) {
            new Label(innerPane, 0).setText(MSG_DATA_SET);
            this.dataSetCombo = new Combo(innerPane, 2060);
            this.dataSetCombo.setLayoutData((Object)new GridData(768));
            String[] dataSets = ChoiceSetFactory.getDataSets();
            String[] newList = new String[dataSets.length + 1];
            System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
            newList[0] = NONE;
            this.dataSetCombo.setItems(newList);
            this.dataSetCombo.select(0);
        } else {
            Label lb = new Label(composite, 0);
            gdata = new GridData(768);
            gdata.horizontalSpan = 2;
            lb.setLayoutData((Object)gdata);
        }
        this.chkbox = new Button(composite, 32);
        this.chkbox.setText(this.insertTable ? MSG_REMEMBER_DIMENSIONS_FOR_NEW_TABLES : MSG_REMEMBER_DIMENSIONS_FOR_NEW_GRIDS);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.chkbox.setLayoutData((Object)gdata);
        if (this.insertTable) {
            UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.TableOptionDialog_ID");
        } else {
            UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.GridOptionDialog_ID");
        }
        return composite;
    }

    protected void okPressed() {
        try {
            this.rowCount = Integer.parseInt(this.rowEditor.getText());
        }
        catch (NumberFormatException e) {
            this.rowCount = this.insertTable ? 1 : 3;
        }
        try {
            this.columnCount = Integer.parseInt(this.columnEditor.getText());
        }
        catch (NumberFormatException e) {
            this.columnCount = 3;
        }
        if (this.columnCount <= 0) {
            this.columnCount = 3;
        }
        if (this.rowCount <= 0) {
            int n = this.rowCount = this.insertTable ? 1 : 3;
        }
        if (this.insertTable) {
            this.setResult(new Object[]{new Integer(this.rowCount), new Integer(this.columnCount), this.dataSetCombo.getItem(this.dataSetCombo.getSelectionIndex()).toString()});
        } else {
            this.setResult(new Object[]{new Integer(this.rowCount), new Integer(this.columnCount)});
        }
        if (this.chkbox.getSelection()) {
            this.savePreference();
        }
        super.okPressed();
    }

    static class SimpleSpinner
    extends Composite {
        private static final int BUTTON_WIDTH = 16;
        private Text text = new Text((Composite)this, 2052);
        private Button up;
        private Button down;

        public SimpleSpinner(Composite parent, int style) {
            super(parent, style);
            this.text.addVerifyListener(new VerifyListener(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void verifyText(VerifyEvent e) {
                    if (e.keyCode == 8 || e.keyCode == 127) {
                        e.doit = true;
                        return;
                    }
                    try {
                        if (e.text.length() != 0) {
                            Integer.parseInt(e.text);
                        }
                        e.doit = true;
                    }
                    catch (Exception _) {
                        e.doit = false;
                    }
                }
            });
            this.text.addFocusListener((FocusListener)new FocusAdapter(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void focusGained(FocusEvent e) {
                    SimpleSpinner.access$000(this.this$0).selectAll();
                }
            });
            this.up = new Button((Composite)this, style | 4 | 0x80);
            this.down = new Button((Composite)this, style | 4 | 0x400);
            this.up.addListener(13, new Listener(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    this.this$0.up();
                }
            });
            this.down.addListener(13, new Listener(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    this.this$0.down();
                }
            });
            this.addListener(11, new Listener(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    this.this$0.resize();
                }
            });
            this.addListener(15, new Listener(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    this.this$0.focusIn();
                }
            });
            this.initAccessible();
        }

        void initAccessible() {
            AccessibleAdapter accessibleAdapter = new AccessibleAdapter(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void getName(AccessibleEvent e) {
                    this.getHelp(e);
                }

                public void getHelp(AccessibleEvent e) {
                    e.result = this.this$0.getToolTipText();
                }
            };
            this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
            this.up.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
            this.down.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
            this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void getCaretOffset(AccessibleTextEvent e) {
                    e.offset = SimpleSpinner.access$000(this.this$0).getCaretPosition();
                }
            });
            this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(this){
                private final /* synthetic */ SimpleSpinner this$0;
                {
                    this.this$0 = this$0;
                }

                public void getChildAtPoint(AccessibleControlEvent e) {
                    Point pt = this.this$0.toControl(new Point(e.x, e.y));
                    e.childID = this.this$0.getBounds().contains(pt) ? -1 : -2;
                }

                public void getLocation(AccessibleControlEvent e) {
                    Rectangle location = this.this$0.getBounds();
                    Point pt = this.this$0.toDisplay(location.x, location.y);
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }

                public void getChildCount(AccessibleControlEvent e) {
                    e.detail = 0;
                }

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 46;
                }

                public void getState(AccessibleControlEvent e) {
                    e.detail = 0;
                }
            });
        }

        void setText(String val) {
            if (this.text != null) {
                this.text.setText(val);
            }
        }

        String getText() {
            if (this.text != null) {
                return this.text.getText();
            }
            return null;
        }

        void up() {
            if (this.text != null) {
                try {
                    int v = Integer.parseInt(this.text.getText());
                    this.text.setText(String.valueOf(v + 1));
                }
                catch (NumberFormatException e) {
                    this.text.setText(String.valueOf(1));
                }
            }
        }

        void down() {
            if (this.text != null) {
                try {
                    int v = Integer.parseInt(this.text.getText());
                    if (v < 2) {
                        v = 2;
                    }
                    this.text.setText(String.valueOf(v - 1));
                }
                catch (NumberFormatException e) {
                    this.text.setText(String.valueOf(1));
                }
            }
        }

        void focusIn() {
            if (this.text != null) {
                this.text.setFocus();
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(80, 20);
        }

        void resize() {
            Point pt = this.computeSize(-1, -1);
            this.setSize(pt);
            int textWidth = pt.x - 16;
            this.text.setBounds(0, 0, textWidth, pt.y);
            int buttonHeight = pt.y / 2;
            this.up.setBounds(textWidth, 0, 16, buttonHeight);
            this.down.setBounds(textWidth, pt.y - buttonHeight, 16, buttonHeight);
        }

        static /* synthetic */ Text access$000(SimpleSpinner x0) {
            return x0.text;
        }
    }
}

