/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.js;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JSPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String JS_DEFAULT = "__js_default";
    public static final String JS_COMMENT = "__js_comment";
    public static final String JS_KEYWORD = "__js_keyword";
    public static final String JS_STRING = "__js_string";
    public static final IToken TOKEN_STRING = new Token((Object)"__js_string");
    public static final IToken TOKEN_COMMENT = new Token((Object)"__js_comment");
    public static final IToken TOKEN_DEFAULT = new Token((Object)"__js_default");
    public static final IToken TOKEN_KEYWORD = new Token((Object)"__js_keyword");
    private static String[] keywordTokens = new String[]{"break", "case", "catch", "continue", "default", "do", "else", "for", "function", "goto", "if", "in", "new", "return", "switch", "this", "throw", "try", "var", "void", "while", "with"};
    private static String[] constantTokens = new String[]{"false", "null", "true"};

    public JSPartitionScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("/*", "*/", TOKEN_COMMENT));
        rules.add(new EndOfLineRule("//", TOKEN_COMMENT));
        rules.add(new SingleLineRule("\"", "\"", TOKEN_STRING, '\\'));
        rules.add(new SingleLineRule("'", "'", TOKEN_STRING, '\\'));
        PredicateWordRule keywordRule = new PredicateWordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c);
            }
        }, TOKEN_DEFAULT);
        keywordRule.addWords(JSPartitionScanner.keywordTokens, JSPartitionScanner.TOKEN_KEYWORD);
        keywordRule.addWords(JSPartitionScanner.constantTokens, JSPartitionScanner.TOKEN_KEYWORD);
        rules.add((Object)keywordRule);
        this.setRuleList(rules);
    }

    private void setRuleList(List rules) {
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    protected void addWords(WordRule rule, String[] tokens, IToken token) {
        for (int i = 0; i < tokens.length; ++i) {
            rule.addWord(tokens[i], token);
        }
    }

    private class PredicateWordRule
    extends WordRule
    implements IPredicateRule {
        public PredicateWordRule(IWordDetector detector, IToken defaultToken) {
            super(detector, defaultToken);
        }

        public IToken getSuccessToken() {
            return Token.UNDEFINED;
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return null;
        }

        private void addWords(String[] tokens, IToken token) {
            for (int i = 0; i < tokens.length; ++i) {
                this.addWord(tokens[i], token);
            }
        }
    }
}

