/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileContentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceLocator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ResourceFileFolderSelectionDialog
extends ElementTreeSelectionDialog {
    private File rootFile;

    public ResourceFileFolderSelectionDialog() {
        this(true, false, null);
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles) {
        this(showFiles, false, null);
    }

    public ResourceFileFolderSelectionDialog(String[] fileNamePattern) {
        this(true, false, fileNamePattern);
    }

    public ResourceFileFolderSelectionDialog(boolean includeFragments, String[] fileNamePattern) {
        this(true, includeFragments, fileNamePattern);
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles, boolean includeFragments, String[] fileNamePattern) {
        this(UIUtil.getDefaultShell(), (ILabelProvider)new ResourceFileLabelProvider(), new ResourceFileContentProvider(showFiles));
        if (includeFragments) {
            this.setInput(ResourceLocator.getRootEntries(fileNamePattern));
        } else {
            this.setInput(ResourceLocator.getResourceFolder(fileNamePattern));
        }
    }

    private ResourceFileFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setSorter(new FileViewerSorter());
    }

    public void setInput(Object input) {
        this.rootFile = new File(input.toString());
        super.setInput(input);
    }

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected.length > 0 && this.rootFile != null) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            return ResourceLocator.relativize(entry.getURL());
        }
        return null;
    }

    public String getPath(int index) {
        Object[] selected = this.getResult();
        if (index < 0 || index >= selected.length || this.rootFile == null) {
            return null;
        }
        ResourceEntry entry = (ResourceEntry)selected[index];
        return ResourceLocator.relativize(entry.getURL());
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ResourceSelectDialog_ID");
        Control control = super.createDialogArea(parent);
        this.addToolTip();
        return control;
    }

    protected void addToolTip() {
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null) {
                        tree.setToolTipText(null);
                    } else if (ResourceFileFolderSelectionDialog.this.getTreeViewer().getLabelProvider() instanceof ResourceFileLabelProvider) {
                        tree.setToolTipText(((ResourceFileLabelProvider)ResourceFileFolderSelectionDialog.this.getTreeViewer().getLabelProvider()).getToolTip(item.getData()));
                    } else {
                        tree.setToolTipText(null);
                    }
                }
            }
        });
    }

    private static class FileViewerSorter
    extends ViewerSorter {
        private FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File && !((File)element).isDirectory()) {
                return 1;
            }
            return 0;
        }
    }
}

