/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ResourceSelectionValidator
implements ISelectionStatusValidator {
    private boolean multiSelect;
    private boolean acceptFolders;
    private String[] ext;
    private String extWrongMessage;
    private Status EmptyStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ResourceSelectionValidator.EmptyError"), null);
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);

    public ResourceSelectionValidator(boolean multiSelect, boolean acceptFolders, String[] ext) {
        this.multiSelect = multiSelect;
        this.acceptFolders = acceptFolders;
        this.ext = ext;
        if (ext != null) {
            this.extWrongMessage = Messages.getString((String)"ResourceSelectionValidator.ExtError");
            for (int i = 0; i < ext.length; ++i) {
                if (i > 0) {
                    this.extWrongMessage = this.extWrongMessage + Messages.getString((String)"ResourceSelectionValidator.ExtErrorSplitter");
                }
                this.extWrongMessage = this.extWrongMessage + ext[i];
            }
        }
    }

    public ResourceSelectionValidator() {
        this(false, false, null);
    }

    public ResourceSelectionValidator(boolean acceptFolders) {
        this(false, acceptFolders, null);
    }

    public ResourceSelectionValidator(boolean acceptFolders, String[] ext) {
        this(false, acceptFolders, ext);
    }

    public ResourceSelectionValidator(String[] ext) {
        this(false, false, ext);
    }

    public IStatus validate(Object[] selection) {
        int nSelected = selection.length;
        String pluginId = "org.eclipse.birt.report.designer.ui";
        if (nSelected == 0 || nSelected > 1 && !this.multiSelect) {
            return this.EmptyStatus;
        }
        for (int i = 0; i < selection.length; ++i) {
            Object curr = selection[i];
            if (curr instanceof ResourceEntry) {
                ResourceEntry resource = (ResourceEntry)curr;
                if (!this.acceptFolders && !resource.isFile()) {
                    return this.EmptyStatus;
                }
                if (this.ext == null) continue;
                boolean isCorrectExt = false;
                String fileName = resource.getName().toLowerCase();
                for (int j = 0; j < this.ext.length; ++j) {
                    if (!fileName.endsWith(this.ext[j].toLowerCase())) continue;
                    isCorrectExt = true;
                    break;
                }
                if (isCorrectExt) continue;
                return new Status(4, pluginId, 4, this.extWrongMessage, null);
            }
            return this.EmptyStatus;
        }
        return this.OKStatus;
    }
}

