/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreatePlaceHolderPartAction;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportLibraryAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertGroupMenuAction;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.ui.actions.NoneAction;
import org.eclipse.birt.report.designer.ui.actions.ToggleMarginVisibilityAction;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;

public class DesignerActionBarContributor
extends ActionBarContributor {
    public static final String PAGE_SET_GROUP_END = "pageSetGroupEnd";
    public static final String PAGE_SET_GROUP = "pageSetGroup";
    private RegisterActions[] insertElementActions = null;
    private static RegisterActions[] insertActions = new RegisterActions[]{new RegisterActions("Insert Text", GeneralInsertMenuAction.INSERT_TEXT_DISPLAY_TEXT), new RegisterActions("Insert Label", GeneralInsertMenuAction.INSERT_LABEL_DISPLAY_TEXT), new RegisterActions("Insert Data", GeneralInsertMenuAction.INSERT_DATA_DISPLAY_TEXT), new RegisterActions("Insert Image", GeneralInsertMenuAction.INSERT_IMAGE_DISPLAY_TEXT), new RegisterActions("Insert Grid", GeneralInsertMenuAction.INSERT_GRID_DISPLAY_TEXT), new RegisterActions("Insert List", GeneralInsertMenuAction.INSERT_LIST_DISPLAY_TEXT), new RegisterActions("Insert Table", GeneralInsertMenuAction.INSERT_TABLE_DISPLAY_TEXT), new RegisterActions("Insert Dynamic Text", GeneralInsertMenuAction.INSERT_DYNAMIC_TEXT_DISPLAY_TEXT)};
    private static final RegisterActions[] elementActions = new RegisterActions[]{new RegisterActions("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertRowAbove")), new RegisterActions("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertRowBelow")), null, new RegisterActions("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertColumnLeft")), new RegisterActions("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertColumnRight")), null, new RegisterActions("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge", Messages.getString((String)"DesignerActionBarContributor.element.merge")), new RegisterActions("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction", Messages.getString((String)"DesignerActionBarContributor.element.split")), null, new RegisterActions(CreatePlaceHolderPartAction.ID, Messages.getString((String)"CreatePlaceHolderAction.text")), new RegisterActions("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToReportItemAction", Messages.getString((String)"RevertToReportItemAction.text")), null, new RegisterActions("AddGroupAction", Messages.getString((String)"DesignerActionBarContributor.element.group"))};
    private static final RegisterActions[] dataActions = new RegisterActions[]{new RegisterActions("org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction", Messages.getString((String)"designerActionBarContributor.menu.data-newdatasource")), new RegisterActions("org.eclipse.birt.report.designer.ui.actions.NewDataSetAction", Messages.getString((String)"designerActionBarContributor.menu.data-newdataset"))};
    private static final RegisterActions[] parameterActions = new RegisterActions[]{new RegisterActions("org.eclipse.birt.report.designer.ui.actions.newScalarParameter", Messages.getString((String)"ParametersNodeProvider.menu.text.parameter")), new RegisterActions("org.eclipse.birt.report.designer.ui.actions.newCascadingParameterGroup", Messages.getString((String)"ParametersNodeProvider.menu.text.cascadingParameter")), new RegisterActions("org.eclipse.birt.report.designer.ui.actions.newParameterGroup", Messages.getString((String)"ParametersNodeProvider.menu.text.group"))};

    protected void buildActions() {
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomInRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomOutRetargetAction());
        this.addRetargetAction(new RetargetAction(ActionFactory.CUT.getId(), null));
        this.addRetargetAction(new RetargetAction(ActionFactory.COPY.getId(), null));
        this.addRetargetAction(new RetargetAction(ActionFactory.PASTE.getId(), null));
        this.addRetargetAction(new RetargetAction("ImportCSSStyleAction", ImportCSSStyleAction.ACTION_TEXT));
        this.addRetargetAction(new RetargetAction("AddStyleAction", Messages.getString((String)"DesignerActionBarContributor.style.new")));
        this.addRetargetAction(new RetargetAction("apply style menu", null));
        this.addRetargetAction(new RetargetAction("edit style menu", null));
        this.addRetargetAction(new RetargetAction("edit group menu", null));
        this.addRetargetAction(new RetargetAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction", null));
        this.registerActions(new RegisterActions[]{new RegisterActions("org.eclipse.gef.toggle_ruler_visibility", Messages.getString((String)"DesignerActionBarContributor.menu.element-showRuler"), 2)});
        this.registerActions(new RegisterActions[]{new RegisterActions("Toggle Margin Visibility", ToggleMarginVisibilityAction.LABEL, 2)});
        this.registerActions(this.getInsertElementActions());
        this.registerActions(elementActions);
        this.registerActions(dataActions);
        this.addRetargetAction(new RetargetAction("UseLibraryAction", ImportLibraryAction.ACTION_TEXT));
        this.registerActions(parameterActions);
    }

    private RegisterActions[] getInsertElementActions() {
        if (this.insertElementActions == null) {
            this.insertElementActions = insertActions;
            List extensionPoints = ExtensionPointManager.getInstance().getExtendedElementPoints();
            if (!extensionPoints.isEmpty()) {
                this.insertElementActions = new RegisterActions[insertActions.length + extensionPoints.size()];
                for (int i = 0; i < insertActions.length; ++i) {
                    this.insertElementActions[i] = insertActions[i];
                }
                for (int k = 0; k < extensionPoints.size(); ++k) {
                    RegisterActions extAction;
                    ExtendedElementUIPoint point = (ExtendedElementUIPoint)extensionPoints.get(k);
                    IElementDefn extension = DesignEngine.getMetaDataDictionary().getExtension(point.getExtensionName());
                    String displayName = new String();
                    displayName = extension.getDisplayName();
                    if (displayName.equalsIgnoreCase("Chart")) {
                        displayName = "&" + displayName;
                    }
                    this.insertElementActions[DesignerActionBarContributor.insertActions.length + k] = extAction = new RegisterActions(extension.getName(), displayName);
                }
            }
        }
        return this.insertElementActions;
    }

    private void registerActions(RegisterActions[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null) continue;
            this.addRetargetAction(new RetargetAction(actions[i].id, actions[i].displayName, actions[i].style));
        }
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.PRINT.getId());
        this.addGlobalActionKey(ActionFactory.SELECT_ALL.getId());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator());
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        tbm.add((IContributionItem)new ZoomComboContributionItem((IPartService)this.getPage(), zoomStrings));
    }

    public void contributeToMenu(IMenuManager menubar) {
        super.contributeToMenu(menubar);
        this.updateEditMenu((IContributionManager)menubar);
        MenuManager newMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.data"));
        newMenu.add(this.getAction(DesignerActionBarContributor.dataActions[0].id));
        newMenu.add(this.getAction(DesignerActionBarContributor.dataActions[1].id));
        MenuManager editGroupMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.data-NewParameter"));
        this.contributeActionsToMenu(editGroupMenu, parameterActions);
        newMenu.add((IContributionItem)editGroupMenu);
        menubar.insertAfter("edit", (IContributionItem)newMenu);
        newMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element"));
        this.contributeActionsToMenu(newMenu, elementActions);
        MenuManager InsertGroupMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.element.group"), "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction");
        InsertGroupMenu.add((IAction)NoneAction.getInstance());
        InsertGroupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateInsertGroupMenu("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction", manager);
            }
        });
        newMenu.add((IContributionItem)InsertGroupMenu);
        editGroupMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element-EditGroup"));
        editGroupMenu.add((IAction)NoneAction.getInstance());
        editGroupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateDynamicItems("edit group menu", manager);
            }
        });
        newMenu.add((IContributionItem)editGroupMenu);
        newMenu.add((IContributionItem)new Separator());
        this.contributeStyleMenu(newMenu);
        newMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem addGroupMenu = manager.findUsingPath("AddGroupAction");
                IContributionItem insertGroupMenus = manager.findUsingPath("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction");
                if (addGroupMenu == null || insertGroupMenus == null) {
                    return;
                }
                RetargetAction action = (RetargetAction)DesignerActionBarContributor.this.getAction("AddGroupAction");
                if (action != null && action.getActionHandler() instanceof AddGroupAction) {
                    if (action.getActionHandler().isEnabled()) {
                        addGroupMenu.setVisible(true);
                        insertGroupMenus.setVisible(false);
                    } else {
                        addGroupMenu.setVisible(false);
                        insertGroupMenus.setVisible(true);
                    }
                    manager.update(true);
                }
            }
        });
        menubar.insertAfter("edit", (IContributionItem)newMenu);
        menubar.insertAfter("edit", (IContributionItem)this.createPageMenu());
        newMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.insert"));
        this.contributeActionsToMenu(newMenu, this.getInsertElementActions());
        newMenu.add((IContributionItem)new Separator());
        newMenu.add(this.getAction("UseLibraryAction"));
        menubar.insertAfter("edit", (IContributionItem)newMenu);
        menubar.update();
    }

    private void contributeActionsToMenu(MenuManager menu, RegisterActions[] actions) {
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] != null) {
                menu.add(this.getAction(actions[i].id));
                continue;
            }
            menu.add((IContributionItem)new Separator());
        }
    }

    protected IMenuManager createPageMenu() {
        MenuManager newMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.page"), "birtPage");
        newMenu.add((IContributionItem)new Separator(PAGE_SET_GROUP));
        newMenu.add((IContributionItem)new Separator(PAGE_SET_GROUP_END));
        newMenu.add((IContributionItem)new Separator());
        return newMenu;
    }

    private void contributeStyleMenu(MenuManager newMenu) {
        newMenu.add(this.getAction("ImportCSSStyleAction"));
        newMenu.add(this.getAction("AddStyleAction"));
        MenuManager editStyleMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.style-rule-edit"));
        editStyleMenu.add((IAction)NoneAction.getInstance());
        editStyleMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateDynamicItems("edit style menu", manager);
            }
        });
        newMenu.add((IContributionItem)editStyleMenu);
        MenuManager applyStyleMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.style-rule-apply"));
        applyStyleMenu.add((IAction)NoneAction.getInstance());
        applyStyleMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateDynamicItems("apply style menu", manager);
            }
        });
        newMenu.add((IContributionItem)applyStyleMenu);
    }

    private void updateDynamicItems(String actionId, IMenuManager menu) {
        RetargetAction action = (RetargetAction)this.getAction(actionId);
        if (action != null && action.getActionHandler() instanceof MenuUpdateAction) {
            ((MenuUpdateAction)action.getActionHandler()).updateMenu((MenuManager)menu);
        }
    }

    private void updateInsertGroupMenu(String actionId, IMenuManager menu) {
        RetargetAction action = (RetargetAction)this.getAction(actionId);
        if (action != null && action.getActionHandler() instanceof InsertGroupMenuAction) {
            ((InsertGroupMenuAction)action.getActionHandler()).updateMenu((MenuManager)menu);
        }
    }

    private void updateEditMenu(IContributionManager menubar) {
        IContributionItem editMenu = menubar.find("edit");
        if (editMenu instanceof IMenuManager) {
            ((IMenuManager)editMenu).addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    this.refreshUpdateAction(ActionFactory.CUT.getId());
                    this.refreshUpdateAction(ActionFactory.COPY.getId());
                    this.refreshUpdateAction(ActionFactory.PASTE.getId());
                    this.refreshUpdateAction(ActionFactory.DELETE.getId());
                }

                private void refreshUpdateAction(String actionId) {
                    RetargetAction action;
                    if (DesignerActionBarContributor.this.getActionRegistry() != null && (action = (RetargetAction)DesignerActionBarContributor.this.getAction(actionId)) != null && action.getActionHandler() != null && action.getActionHandler() instanceof UpdateAction) {
                        ((UpdateAction)action.getActionHandler()).update();
                    }
                }
            });
        }
    }

    static class RegisterActions {
        String id;
        String displayName;
        int style;

        public RegisterActions(String id, String displayName) {
            this(id, displayName, 0);
        }

        public RegisterActions(String id, String displayName, int style) {
            this.id = id;
            this.displayName = displayName;
            this.style = style;
        }
    }
}

