/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.StyleException;

public class ApplyStyleAction
extends MenuUpdateAction.DynamicItemAction {
    public static final String ID = "ApplyStyleAction";
    private static final String STACK_MSG_APPLY_STYLE = Messages.getString((String)"ApplyStyleAction.stackMsg.applyStyle");
    private SharedStyleHandle handle;
    private List selectionHandles;

    public ApplyStyleAction(SharedStyleHandle handle) {
        this.handle = handle;
        this.setId(ID);
        if (handle == null) {
            this.setText(Messages.getString((String)"ApplyStyleAction.actionLabel.none"));
        } else if (handle.getContainerSlotHandle().getElementHandle() instanceof ThemeHandle) {
            this.setText(((ThemeHandle)handle.getContainerSlotHandle().getElementHandle()).getName() + "." + DEUtil.getEscapedMenuItemText((String)handle.getDisplayLabel()));
        } else {
            this.setText(DEUtil.getEscapedMenuItemText((String)handle.getDisplayLabel()));
        }
    }

    public boolean isEnabled() {
        List handles = this.getElementHandles();
        if (handles.isEmpty()) {
            return false;
        }
        for (int i = 0; i < handles.size(); ++i) {
            if (!(handles.get(i) instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle handle = (DesignElementHandle)handles.get(i);
            if (handle == null || handle.getDefn().hasStyle()) continue;
            return false;
        }
        return true;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Apply style rule action >> Run ...");
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(STACK_MSG_APPLY_STYLE);
        try {
            List handles = this.getElementHandles();
            for (int i = 0; i < handles.size(); ++i) {
                ((DesignElementHandle)handles.get(i)).setStyle(this.isChecked() ? this.handle : null);
            }
            stack.commit();
        }
        catch (StyleException e) {
            stack.rollbackAll();
            ExceptionHandler.handle(e);
        }
    }

    protected List getElementHandles() {
        if (this.selectionHandles == null) {
            this.selectionHandles = InsertInLayoutUtil.editPart2Model(TableUtil.filletCellInSelectionEditorpart(this.getSelection())).toList();
        }
        return this.selectionHandles;
    }
}

